/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class Create {

    public static class LowHeated {
        static Emitter.Properties<?> basicBurner() {
            String id = "createlowheated:basic_burner:*";
            return ((Emitter.Properties)((Emitter.Properties)Emitter.Properties.tile("BurnTimeRemaining").id(id)).relatedBlocks(new String[]{id})).maxGapLength(2);
        }

        public static Emitter.Properties<?> litBurner() {
            return ((Emitter.Properties)LowHeated.basicBurner().metadata("[empowered=false]")).smoke(1, 0.5f);
        }

        public static Emitter.Properties<?> empoweredBurner() {
            return ((Emitter.Properties)LowHeated.basicBurner().metadata("[empowered=true]")).smoke(4, 2.0f);
        }
    }

    public static class DieselGenerators {
        public static final String MOD_ID = "createdieselgenerators";

        public static Emitter.Properties<?> burner() {
            return Emitter.Properties.tile("Heat").smoke(1, 0.5f);
        }

        public static Emitter.Properties<?> engine(String name) {
            return ((Emitter.Properties)((Object)((Emitter.Properties)Emitter.Properties.with().id(UnitId.from((String)MOD_ID, (String)name).withMetaAll())).customFactory(Engine::new))).smoke(1, 1.0f, 2.0f);
        }

        public static Emitter.Properties<?> silencedEngine(String name) {
            return ((Emitter.Properties)DieselGenerators.engine(name).metadata("[silenced=true]")).smoke(1, 0.1f, 1.0f);
        }

        public static Emitter.Properties<?> turbochargedEngine(String name) {
            return ((Emitter.Properties)DieselGenerators.engine(name).metadata("[turbocharged=true]")).smoke(2, 1.5f, 2.0f);
        }

        public static class Engine
        extends Emitter {
            public Engine(@Nullable UnitConfig config, Emitter.Properties<?> props) {
                super(config, (Emitter.Properties)props.activeTag("#hardcoded_speed_check"));
            }

            public boolean isActive(INBTSource<?> nbtSource) {
                CompoundTag compound = nbtSource.serialize();
                float speed = compound.getFloat("Speed");
                return speed != 0.0f;
            }
        }
    }
}

