/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.Stats;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class Commands {
    public static void reloadEmitters(ServerCommand.Context context) {
        AdChimneys.getInstance().emitters.reloadConfigs();
        context.sendMessage("Configs for emitters reloaded");
    }

    public static void identifyEmitter(ServerCommand.Context context) {
        BlockPos pos;
        ServerLevel world;
        Emitter emitter;
        Optional info = context.getTargetBlockInfo(false);
        if (info.isPresent() && (emitter = (Emitter)AdChimneys.getInstance().emitters.get((LevelReader)(world = context.getLevel()), pos = (BlockPos)((Pair)info.get()).getKey()).orElse(null)) != null) {
            String name = ((ServerCommand.Msg)((Pair)info.get()).getValue()).toString();
            context.sendMessage(ServerCommand.Msg.emitter((String)name, (IEmitter)emitter, (boolean)emitter.isActive((LevelReader)world, pos)));
            return;
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No emitter found"));
    }

    public static void identifyBlock(ServerCommand.Context context) {
        context.getTargetBlockInfo(true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyTile(ServerCommand.Context context) {
        context.getTargetTileInfo(IEmitter.COMMON_ACTIVE_TAG_NAME, true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void listEmitters(ServerCommand.Context context) {
        Commands.logListOf("Emitters", AdChimneys.getInstance().emitters.streamAll().toList(), context);
    }

    public static void showStats(ServerCommand.Context context) {
        WorldData data = WorldData.getData((LevelAccessor)context.getLevel());
        Stats stats = Stats.of(ChatFormatting.DARK_AQUA, ChatFormatting.YELLOW);
        SmokeLocations locations = data.getSmokeLocations();
        stats.group("Smoke").value("sources", locations.getSourcesTotal()).value("outlets", locations.getOutletsTotal());
        Emitters emitters = AdChimneys.getInstance().emitters;
        stats.group("Emitters").value("loaded", emitters.mapAll().size()).value("known", emitters.streamAll().filter(e -> e.getRelatedId().getFirstMatchedState() != null).mapToInt(e -> 1).sum());
        for (String text : stats.toList()) {
            context.sendMessage(text);
        }
        context.sendMessage("");
    }

    private static <O> void logListOf(String title, Collection<O> list, ServerCommand.Context context) {
        Logger logger = AdChimneys.getInstance().getLogger();
        logger.debug(title + "[" + list.size() + "]: {");
        list.stream().map(Objects::toString).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.debug("}");
        context.sendMessage("List of all " + title.toLowerCase() + " was written to .minecraft/logs/debug.log");
    }
}

