/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;

class ResourceEmiDragDropHandler
implements EmiDragDropHandler<Screen> {
    ResourceEmiDragDropHandler() {
    }

    public boolean dropStack(Screen screen, EmiIngredient stack, int x, int y) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return false;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractResourceContainerMenu)) {
            return false;
        }
        AbstractResourceContainerMenu menu = (AbstractResourceContainerMenu)abstractContainerMenu;
        return RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)stack).map(resource -> this.dropStack(menu, (AbstractBaseScreen<?>)baseScreen, (PlatformResourceKey)resource, x, y)).orElse(false);
    }

    private boolean dropStack(AbstractResourceContainerMenu menu, AbstractBaseScreen<?> baseScreen, PlatformResourceKey resource, int x, int y) {
        for (ResourceSlot slot : menu.getResourceSlots()) {
            if (!this.dropStack(resource, slot, x, y, baseScreen)) continue;
            return true;
        }
        return false;
    }

    private boolean dropStack(PlatformResourceKey resource, ResourceSlot slot, int x, int y, AbstractBaseScreen<?> baseScreen) {
        if (!ResourceEmiDragDropHandler.isSlotValid(resource, slot)) {
            return false;
        }
        int slotX = baseScreen.getLeftPos() + slot.x;
        int slotY = baseScreen.getTopPos() + slot.y;
        if (x < slotX || y < slotY || x > slotX + 16 || y > slotY + 16) {
            return false;
        }
        C2SPackets.sendResourceFilterSlotChange((PlatformResourceKey)resource, (int)slot.index);
        return true;
    }

    public void render(Screen screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractResourceContainerMenu)) {
            return;
        }
        AbstractResourceContainerMenu menu = (AbstractResourceContainerMenu)abstractContainerMenu;
        RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)dragged).ifPresent(resource -> {
            EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
            for (ResourceSlot slot : menu.getResourceSlots()) {
                if (!ResourceEmiDragDropHandler.isSlotValid(resource, slot)) continue;
                context.fill(baseScreen.getLeftPos() + slot.x, baseScreen.getTopPos() + slot.y, 17, 17, -2010989773);
            }
        });
    }

    private static boolean isSlotValid(PlatformResourceKey resource, ResourceSlot slot) {
        return slot.isFilter() && slot.isActive() && slot.isValid((ResourceKey)resource);
    }
}

