/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.FilterSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

class FilterEmiDragDropHandler
implements EmiDragDropHandler<Screen> {
    FilterEmiDragDropHandler() {
    }

    public boolean dropStack(Screen screen, EmiIngredient stack, int x, int y) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return false;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractBaseContainerMenu)) {
            return false;
        }
        AbstractBaseContainerMenu menu = (AbstractBaseContainerMenu)abstractContainerMenu;
        if (!(stack instanceof ItemEmiStack)) {
            return false;
        }
        ItemEmiStack emiStack = (ItemEmiStack)stack;
        return this.dropStack(menu, baseScreen, emiStack.getItemStack(), x, y);
    }

    private boolean dropStack(AbstractBaseContainerMenu menu, AbstractBaseScreen<?> baseScreen, ItemStack stack, int x, int y) {
        for (Slot slot : menu.slots) {
            FilterSlot filterSlot;
            if (!(slot instanceof FilterSlot) || !this.dropStack(stack, filterSlot = (FilterSlot)slot, x, y, baseScreen)) continue;
            return true;
        }
        return false;
    }

    private boolean dropStack(ItemStack stack, FilterSlot slot, int x, int y, AbstractBaseScreen<?> baseScreen) {
        if (!FilterEmiDragDropHandler.isSlotValid(stack, slot)) {
            return false;
        }
        int slotX = baseScreen.getLeftPos() + slot.x;
        int slotY = baseScreen.getTopPos() + slot.y;
        if (x < slotX || y < slotY || x > slotX + 16 || y > slotY + 16) {
            return false;
        }
        C2SPackets.sendFilterSlotChange((ItemStack)stack, (int)slot.index);
        return true;
    }

    public void render(Screen screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Object e;
        if (!(screen instanceof AbstractBaseScreen)) {
            return;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractBaseContainerMenu)) {
            return;
        }
        AbstractBaseContainerMenu menu = (AbstractBaseContainerMenu)abstractContainerMenu;
        if (dragged.isEmpty() || !((e = dragged.getEmiStacks().getFirst()) instanceof ItemEmiStack)) {
            return;
        }
        ItemEmiStack emiStack = (ItemEmiStack)e;
        ItemStack stack = emiStack.getItemStack();
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        for (Slot slot : menu.slots) {
            FilterSlot filterSlot;
            if (!(slot instanceof FilterSlot) || !FilterEmiDragDropHandler.isSlotValid(stack, filterSlot = (FilterSlot)slot)) continue;
            context.fill(baseScreen.getLeftPos() + slot.x, baseScreen.getTopPos() + slot.y, 17, 17, -2010989773);
        }
    }

    private static boolean isSlotValid(ItemStack stack, FilterSlot slot) {
        return slot.isActive() && slot.mayPlace(stack);
    }
}

