/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public class MoveAbilityPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<MoveAbilityPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"move_ability"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MoveAbilityPacket> CODEC = MoveAbilityPacket.getCodec(MoveAbilityPacket::new);
    @CodecField
    private String abilityName;
    @CodecField
    private int abilityLevel;
    @CodecField
    private int movement;

    public MoveAbilityPacket() {
        super(TYPE);
    }

    public MoveAbilityPacket(Registry<IAbilityType> registry, Ability ability, Movement movement) {
        this();
        this.abilityName = registry.getKey((Object)ability.getAbilityType()).toString();
        this.abilityLevel = ability.getLevel();
        this.movement = movement.ordinal();
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (player.containerMenu instanceof ContainerAbilityContainer) {
            ContainerAbilityContainer container = (ContainerAbilityContainer)player.containerMenu;
            Optional abilityTypeOptional = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(world.registryAccess()).getHolder(ResourceLocation.parse((String)this.abilityName));
            if (abilityTypeOptional.isPresent()) {
                Ability ability = new Ability((Holder<IAbilityType>)((Holder)abilityTypeOptional.get()), this.abilityLevel);
                container.getPlayerAbilityStore().ifPresent(playerAbilityStore -> container.getItemAbilityStore().ifPresent(itemAbilityStore -> {
                    if (this.movement == Movement.FROM_PLAYER.ordinal()) {
                        if (EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canExtract(ability, (IMutableAbilityStore)playerAbilityStore) && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsert(ability, (IMutableAbilityStore)itemAbilityStore)) {
                            container.moveFromPlayer(ability);
                        }
                    } else if (EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canExtract(ability, (IMutableAbilityStore)itemAbilityStore) && EverlastingAbilitiesInstance.MOD.getAbilityHelpers().canInsert(ability, (IMutableAbilityStore)playerAbilityStore)) {
                        container.moveToPlayer(ability);
                    }
                }));
            }
        }
    }

    public static enum Movement {
        TO_PLAYER,
        FROM_PLAYER;

    }
}

