/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeEnum;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.command.argument.ArgumentTypeAbility;

public class CommandModifyAbilities
implements Command<CommandSourceStack> {
    private final boolean checkAbility;
    private final boolean checkLevel;

    public CommandModifyAbilities(boolean checkAbility, boolean checkLevel) {
        this.checkAbility = checkAbility;
        this.checkLevel = checkLevel;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Action action = (Action)ArgumentTypeEnum.getValue(context, (String)"action", Action.class);
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        IMutableAbilityStore abilityStore = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore((Entity)player).get();
        if (action == Action.LIST) {
            sender.sendSystemMessage(abilityStore.getTextComponent());
        } else {
            int level;
            if (!this.checkAbility) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"chat.everlastingabilities.command.invalidAbility", (Object[])new Object[]{"null"})).create();
            }
            Holder<IAbilityType> abilityType = ((ArgumentTypeAbility.Input)context.getArgument("ability", ArgumentTypeAbility.Input.class)).abilityType();
            int n = level = this.checkLevel ? (Integer)context.getArgument("level", Integer.class) : 1;
            if (action == Action.ADD) {
                level = Math.max(1, Math.min(((IAbilityType)abilityType.value()).getMaxLevelInfinitySafe(), level));
                Ability ability = new Ability(abilityType, level);
                Ability addedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().addPlayerAbility((Player)player, ability, true, false);
                Ability newAbility = abilityStore.getAbility(abilityType);
                sender.sendSystemMessage((Component)Component.translatable((String)"chat.everlastingabilities.command.addedAbility", (Object[])new Object[]{addedAbility.getTextComponent(), newAbility.getTextComponent()}));
            } else {
                level = Math.max(1, level);
                Ability ability = new Ability(abilityType, level);
                Ability removedAbility = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().removePlayerAbility((Player)player, ability, true, false);
                Ability newAbility = abilityStore.getAbility(abilityType);
                sender.sendSystemMessage((Component)Component.translatable((String)"chat.everlastingabilities.command.removedAbility", (Object[])new Object[]{removedAbility.getTextComponent(), newAbility.getTextComponent()}));
            }
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make(CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"abilities").requires(commandSource -> commandSource.hasPermission(2))).then(Commands.argument((String)"action", (ArgumentType)new ArgumentTypeEnum(Action.class)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes((Command)new CommandModifyAbilities(false, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"ability", (ArgumentType)new ArgumentTypeAbility(context)).executes((Command)new CommandModifyAbilities(true, false))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes((Command)new CommandModifyAbilities(true, true))))));
    }

    public static enum Action {
        ADD,
        REMOVE,
        LIST;

    }
}

