/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class RenderLivingHandler {
    public static void onRenderLiving(LivingEntity entity) {
        IMutableAbilityStore abilityStore;
        if ((GeneralConfig.showEntityParticles && entity instanceof PathfinderMob || GeneralConfig.showPlayerParticles && entity instanceof Player) && !Minecraft.getInstance().isPaused() && entity.level().getGameTime() % 10L == 0L && (abilityStore = (IMutableAbilityStore)EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore((Entity)entity).orElse(null)) != null && !abilityStore.getAbilities().isEmpty()) {
            Triple<Integer, Integer, Integer> abilityColors = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAverageRarityColor(abilityStore);
            float r = (float)((Integer)abilityColors.getLeft()).intValue() / 255.0f;
            float g = (float)((Integer)abilityColors.getMiddle()).intValue() / 255.0f;
            float b = (float)((Integer)abilityColors.getRight()).intValue() / 255.0f;
            RandomSource rand = entity.level().random;
            float scale = 0.5f - rand.nextFloat() * 0.3f;
            float red = Math.max(0.0f, r - rand.nextFloat() * 0.1f);
            float green = Math.max(0.0f, g - rand.nextFloat() * 0.1f);
            float blue = Math.max(0.0f, b - rand.nextFloat() * 0.1f);
            float ageMultiplier = (float)(rand.nextDouble() * 10.0 + 20.0);
            double x = entity.getX() - 0.1 + rand.nextDouble() * 0.2 + (double)(entity.getBbWidth() / 2.0f * (float)(rand.nextBoolean() ? 1 : -1));
            double y = entity.getY() + (double)entity.getBbHeight() - 0.2 + rand.nextDouble() * 0.4;
            double z = entity.getZ() - 0.1 + rand.nextDouble() * 0.2 + (double)(entity.getBbWidth() / 2.0f * (float)(rand.nextBoolean() ? 1 : -1));
            double motionX = 0.02 - rand.nextDouble() * 0.04;
            double motionY = 0.02 - rand.nextDouble() * 0.04;
            double motionZ = 0.02 - rand.nextDouble() * 0.04;
            Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, x, y, z, motionX, motionY, motionZ);
        }
    }
}

