/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Holder;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;

public class DefaultAbilityStore
implements IAbilityStore {
    protected final Map<Holder<IAbilityType>, Integer> abilityTypes = Maps.newLinkedHashMap();

    public DefaultAbilityStore() {
    }

    public DefaultAbilityStore(Map<Holder<IAbilityType>, Integer> abilityTypes) {
        this.setAbilities(abilityTypes);
    }

    public DefaultAbilityStore(IAbilityStore abilityStore) {
        this(abilityStore.getAbilitiesRaw());
    }

    @Override
    public void setAbilities(Map<Holder<IAbilityType>, Integer> abilityTypes) {
        this.abilityTypes.clear();
        this.abilityTypes.putAll(abilityTypes);
    }

    @Override
    public boolean hasAbilityType(Holder<IAbilityType> abilityType) {
        return this.abilityTypes.containsKey(abilityType);
    }

    @Override
    public Collection<Holder<IAbilityType>> getAbilityTypes() {
        return this.abilityTypes.keySet();
    }

    @Override
    public Collection<Ability> getAbilities() {
        ArrayList abilities = Lists.newArrayList();
        for (Holder<IAbilityType> abilityType : this.getAbilityTypes()) {
            abilities.add(this.getAbility(abilityType));
        }
        return abilities;
    }

    @Override
    public Map<Holder<IAbilityType>, Integer> getAbilitiesRaw() {
        return Collections.unmodifiableMap(this.abilityTypes);
    }

    @Override
    public Ability getAbility(Holder<IAbilityType> abilityType) {
        if (!this.hasAbilityType(abilityType)) {
            return Ability.EMPTY;
        }
        return new Ability(abilityType, this.abilityTypes.get(abilityType));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultAbilityStore) {
            DefaultAbilityStore defaultAbilityStore = (DefaultAbilityStore)obj;
            return this.abilityTypes.equals(defaultAbilityStore.abilityTypes);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.abilityTypes.hashCode();
    }
}

