/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Rarity;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class Ability
implements Comparable<Ability> {
    public static final Ability EMPTY = new Ability((Holder<IAbilityType>)Holder.direct((Object)new AbilityTypeAdapter(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityConditionTrue(), "", Rarity.COMMON, 0, 0, true, true, true, true){

        @Override
        public MapCodec<? extends IAbilityType> codec() {
            return null;
        }
    }), 0);
    private final Holder<IAbilityType> abilityType;
    private final int level;

    public Ability(@Nonnull Holder<IAbilityType> abilityType, int level) {
        this.abilityType = Objects.requireNonNull(abilityType);
        this.level = level;
    }

    public Holder<IAbilityType> getAbilityTypeHolder() {
        return this.abilityType;
    }

    public IAbilityType getAbilityType() {
        return (IAbilityType)this.getAbilityTypeHolder().value();
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return String.format("[%s @ %s]", ((IAbilityType)this.abilityType.value()).getTranslationKey(), this.level);
    }

    @Override
    public int compareTo(Ability other) {
        return this.toString().compareTo(other.toString());
    }

    public Component getTextComponent() {
        return Component.literal((String)"[").append((Component)Component.translatable((String)((IAbilityType)this.abilityType.value()).getTranslationKey())).append(" @ " + this.level + "]");
    }

    public boolean isEmpty() {
        return this.getLevel() <= 0;
    }
}

