/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeSpecialMagnetize
extends AbilityTypeAdapter {
    private final boolean moveXp;

    public AbilityTypeSpecialMagnetize(IAbilityCondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, boolean moveXp) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.moveXp = moveXp;
    }

    @Override
    public MapCodec<? extends IAbilityType> codec() {
        return Objects.requireNonNull((MapCodec)RegistryEntries.ABILITYSERIALIZER_SPECIAL_MAGNETIZE.value());
    }

    public boolean isMoveXp() {
        return this.moveXp;
    }

    @Override
    public void onTick(Player player, int level) {
        Level world = player.level();
        if (!world.isClientSide && !player.isCrouching() && world.getGameTime() % (long)(IModHelpers.get().getMinecraftHelpers().getSecondInTicks() / 20) == 0L) {
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            int area = level * 2;
            AABB box = new AABB(x, y, z, x, y, z).inflate((double)area, (double)area, (double)area);
            List entities = world.getEntities((Entity)player, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity instanceof ItemEntity || AbilityTypeSpecialMagnetize.this.isMoveXp() && entity instanceof ExperienceOrb;
                }
            });
            for (Entity moveEntity : entities) {
                if ((!(moveEntity instanceof ItemEntity) || ((ItemEntity)moveEntity).hasPickUpDelay() || !this.canKineticateItem((ItemEntity)moveEntity)) && !(moveEntity instanceof ExperienceOrb)) continue;
                double dx = moveEntity.getX() - x;
                double dy = moveEntity.getY() - y + 1.0;
                double dz = moveEntity.getZ() - z;
                double strength = -1.0;
                double d = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
                if (!(d > 0.5)) continue;
                double m = 1.0 / (2.0 * Math.max(1.0, d));
                dx *= m;
                dy *= m;
                dz *= m;
                if (moveEntity instanceof ItemEntity && d < 5.0) {
                    ((ItemEntity)moveEntity).setPickUpDelay(0);
                }
                moveEntity.setDeltaMovement(dx * strength, moveEntity.horizontalCollision ? 0.3 : dy * strength, dz * strength);
            }
        }
    }

    protected boolean canKineticateItem(ItemEntity entityItem) {
        return true;
    }
}

