/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.common.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.common.render.block.AzBlockEntityRendererPipelineContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzBlockEntityRendererPipeline<T extends BlockEntity>
extends AzRendererPipeline<Long, T> {
    private final AzBlockEntityRenderer<T> blockEntityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzBlockEntityRendererPipeline(AzBlockEntityRendererConfig config, AzBlockEntityRenderer<T> blockEntityRenderer) {
        super(config);
        this.blockEntityRenderer = blockEntityRenderer;
    }

    protected AzBlockEntityRendererPipelineContext<T> createContext(AzRendererPipeline<Long, T> rendererPipeline) {
        return (AzBlockEntityRendererPipelineContext)this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<Long, T> createModelRenderer(AzLayerRenderer<Long, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<Long, T> createLayerRenderer(AzRendererConfig<Long, T> config) {
        return new AzLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.last().pose());
        float scaleWidth = this.config.scaleWidth((BlockEntity)context.animatable());
        float scaleHeight = this.config.scaleHeight((BlockEntity)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (this.config.alpha((BlockEntity)context.animatable()) < 1.0f) {
            int alpha = (int)(this.config.alpha((BlockEntity)context.animatable()) * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
        }
        this.config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
        context.setTextureOverride(null);
    }

    public AzBlockEntityRenderer<T> getRenderer() {
        return this.blockEntityRenderer;
    }
}

