/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.util.client.RenderUtils;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipelineContext<K, T> {
    public ResourceLocation textureOverride;
    private final AzRendererPipeline<K, T> rendererPipeline;
    protected T animatable;
    @Nullable
    protected Entity currentEntity;
    private AzBakedModel bakedModel;
    private MultiBufferSource multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private PoseStack poseStack;
    private int renderColor;
    @Nullable
    private RenderType renderType;
    private VertexConsumer vertexConsumer;
    protected static final Map<ResourceLocation, IntIntPair> TEXTURE_DIMENSIONS_CACHE = new Object2ObjectOpenHashMap();

    protected AzRendererPipelineContext(AzRendererPipeline<K, T> rendererPipeline) {
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, MultiBufferSource multiBufferSource, int packedLight, float partialTick, PoseStack poseStack, RenderType renderType, VertexConsumer vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        this.vertexConsumer = vertexConsumer;
        this.renderColor = this.getRenderColor(animatable, partialTick, packedLight).argbInt();
        if (renderType == null) {
            AzRendererConfig<K, T> cfg = this.rendererPipeline.config();
            ResourceLocation texture = cfg.textureLocation(this.currentEntity, animatable);
            this.renderType = this.getDefaultRenderType(animatable, texture, multiBufferSource, partialTick, cfg.getRenderType(this.currentEntity, animatable), cfg.alpha(animatable));
        } else {
            this.renderType = renderType;
        }
        if (this.vertexConsumer == null && this.renderType != null) {
            this.vertexConsumer = multiBufferSource.getBuffer(this.renderType);
        }
    }

    public abstract RenderType getDefaultRenderType(T var1, ResourceLocation var2, @Nullable MultiBufferSource var3, float var4, RenderType var5, float var6);

    protected Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    protected int getPackedOverlay(T animatable, float u, float partialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    public AzRendererPipeline<K, T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return this.animatable;
    }

    public void setCurrentEntity(Entity currentEntity) {
        this.currentEntity = currentEntity;
    }

    @Nullable
    public Entity currentEntity() {
        return this.currentEntity;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public MultiBufferSource multiBufferSource() {
        return this.multiBufferSource;
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public PoseStack poseStack() {
        return this.poseStack;
    }

    public int renderColor() {
        return this.renderColor;
    }

    public void setRenderColor(int renderColor) {
        this.renderColor = renderColor;
    }

    @Nullable
    public RenderType renderType() {
        return this.renderType;
    }

    public void setRenderType(@Nullable RenderType renderType) {
        this.renderType = renderType;
    }

    public VertexConsumer vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(VertexConsumer vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public void setTextureOverride(ResourceLocation textureOverride) {
        this.textureOverride = textureOverride;
    }

    public ResourceLocation getTextureOverride() {
        return this.textureOverride;
    }

    public IntIntPair computeTextureSize(ResourceLocation texture) {
        return TEXTURE_DIMENSIONS_CACHE.computeIfAbsent(texture, RenderUtils::getTextureDimensions);
    }
}

