/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.network.packet;

import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorAccessor;
import mod.azure.azurelib.common.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.common.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import mod.azure.azurelib.common.util.client.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record AzBlockEntityDispatchCommandPacket(BlockPos blockPos, AzCommand dispatchCommand) implements AbstractPacket
{
    public static final CustomPacketPayload.Type<AzBlockEntityDispatchCommandPacket> TYPE = new CustomPacketPayload.Type(AzureLibNetwork.AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, AzBlockEntityDispatchCommandPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, AzBlockEntityDispatchCommandPacket::blockPos, AzCommand.CODEC, AzBlockEntityDispatchCommandPacket::dispatchCommand, AzBlockEntityDispatchCommandPacket::new);

    @Override
    public void handle() {
        BlockEntity blockEntity = ClientUtils.getLevel().getBlockEntity(this.blockPos);
        if (blockEntity == null) {
            return;
        }
        AzAnimator animator = AzAnimatorAccessor.getOrNull(blockEntity);
        if (animator != null && animator.context().animatable().getBlockPos().equals((Object)this.blockPos)) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

