/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.model.factory.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.common.cache.object.GeoCube;
import mod.azure.azurelib.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.loading.json.raw.Bone;
import mod.azure.azurelib.common.loading.json.raw.Cube;
import mod.azure.azurelib.common.loading.json.raw.ModelProperties;
import mod.azure.azurelib.common.loading.object.BoneStructure;
import mod.azure.azurelib.common.loading.object.GeometryTree;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.model.AzBoneMetadata;
import mod.azure.azurelib.common.model.factory.AzBakedModelFactory;
import mod.azure.azurelib.common.model.factory.primitive.VertexSet;
import mod.azure.azurelib.common.util.client.RenderUtils;
import net.minecraft.world.phys.Vec3;

public final class AzBuiltinBakedModelFactory
extends AzBakedModelFactory {
    @Override
    public AzBakedModel constructGeoModel(GeometryTree geometryTree) {
        ObjectArrayList bones = new ObjectArrayList();
        for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
            bones.add((Object)this.constructBone(boneStructure, geometryTree.properties(), null));
        }
        return new AzBakedModel((List<AzBone>)bones);
    }

    @Override
    public AzBone constructBone(BoneStructure boneStructure, ModelProperties properties, AzBone parent) {
        Bone bone = boneStructure.self();
        AzBoneMetadata boneMetadata = new AzBoneMetadata(bone, parent);
        AzBone newBone = new AzBone(boneMetadata);
        Vec3 rotation = RenderUtils.arrayToVec(bone.rotation());
        Vec3 pivot = RenderUtils.arrayToVec(bone.pivot());
        newBone.updateRotation((float)Math.toRadians(-rotation.x), (float)Math.toRadians(-rotation.y), (float)Math.toRadians(rotation.z));
        newBone.updatePivot((float)(-pivot.x), (float)pivot.y, (float)pivot.z);
        for (Cube cube : bone.cubes()) {
            newBone.getCubes().add(this.constructCube(cube, properties, newBone));
        }
        for (BoneStructure child : boneStructure.children().values()) {
            newBone.getChildBones().add(this.constructBone(child, properties, newBone));
        }
        return newBone;
    }

    @Override
    public GeoCube constructCube(Cube cube, ModelProperties properties, AzBone bone) {
        boolean mirror;
        boolean bl = mirror = cube.mirror() == Boolean.TRUE;
        double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
        Vec3 size = RenderUtils.arrayToVec(cube.size());
        Vec3 origin = RenderUtils.arrayToVec(cube.origin());
        Vec3 rotation = RenderUtils.arrayToVec(cube.rotation());
        Vec3 pivot = RenderUtils.arrayToVec(cube.pivot());
        origin = new Vec3(-(origin.x + size.x) / 16.0, origin.y / 16.0, origin.z / 16.0);
        Vec3 vertexSize = size.multiply(0.0625, 0.0625, 0.0625);
        pivot = pivot.multiply(-1.0, 1.0, 1.0);
        rotation = new Vec3(Math.toRadians(-rotation.x), Math.toRadians(-rotation.y), Math.toRadians(rotation.z));
        GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
        return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
    }
}

