/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.cache;

import java.util.UUID;
import java.util.WeakHashMap;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.animation.impl.AzItemAnimator;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzIdentifiableItemStackAnimatorCache {
    private static final AzIdentifiableItemStackAnimatorCache INSTANCE = new AzIdentifiableItemStackAnimatorCache();
    private static final WeakHashMap<UUID, AzItemAnimator> ANIMATORS_BY_UUID = new WeakHashMap();

    public static AzIdentifiableItemStackAnimatorCache getInstance() {
        return INSTANCE;
    }

    private AzIdentifiableItemStackAnimatorCache() {
    }

    public void add(ItemStack itemStack, AzItemAnimator animator) {
        UUID uuid = (UUID)itemStack.get(AzureLib.AZ_ID.get());
        if (uuid != null) {
            ANIMATORS_BY_UUID.computeIfAbsent(uuid, $ -> animator);
        }
    }

    @Nullable
    public AzItemAnimator getOrNull(UUID uuid) {
        return uuid == null ? null : ANIMATORS_BY_UUID.get(uuid);
    }
}

