/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.ContainerHolderEntityRenderer;
import net.mehvahdjukaar.snowyspirit.client.GingyEntityRenderer;
import net.mehvahdjukaar.snowyspirit.client.GingyModel;
import net.mehvahdjukaar.snowyspirit.client.GlowLightParticle;
import net.mehvahdjukaar.snowyspirit.client.GlowLightsBakedModel;
import net.mehvahdjukaar.snowyspirit.client.QuiltModel;
import net.mehvahdjukaar.snowyspirit.client.SledEntityRenderer;
import net.mehvahdjukaar.snowyspirit.client.SledModel;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClientRegistry {
    public static final ModelLayerLocation SLED_MODEL = ClientRegistry.loc("sled");
    public static final ModelLayerLocation SLED_MODEL_BAMBOO = ClientRegistry.loc("sled_bamboo");
    public static final ModelLayerLocation QUILT_MODEL = ClientRegistry.loc("quilt");
    public static final ModelLayerLocation GINGY_MODEL = ClientRegistry.loc("gingy");

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(SnowySpirit.res(name), name);
    }

    public static void init() {
        ClientHelper.addModelLayerRegistration(ClientRegistry::registerModelLayers);
        ClientHelper.addEntityRenderersRegistration(ClientRegistry::registerEntityRenderers);
        ClientHelper.addModelLoaderRegistration(ClientRegistry::registerModelLoaders);
        ClientHelper.addBlockColorsRegistration(ClientRegistry::registerBlockColors);
        ClientHelper.addParticleRegistration(ClientRegistry::registerParticles);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModRegistry.GLOW_LIGHT_PARTICLE.get(), GlowLightParticle.Provider::new);
    }

    public static void setup() {
        ClientHelper.registerRenderType((Block)ModRegistry.GINGER_CROP.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.GINGER_WILD.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.SNOW_GLOBE.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.WREATH.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.GINGER_POT.get(), (RenderType)RenderType.cutout());
        for (Supplier<Block> v : ModRegistry.GUMDROPS_BUTTONS.values()) {
            ClientHelper.registerRenderType((Block)v.get(), (RenderType)RenderType.translucent());
        }
        for (Supplier<Block> v : ModRegistry.GLOW_LIGHTS_BLOCKS.values()) {
            ClientHelper.registerRenderType((Block)v.get(), (RenderType)RenderType.cutout());
        }
        ItemProperties.register((Item)ModRegistry.GINGERBREAD_COOKIE.get(), (ResourceLocation)ResourceLocation.parse((String)"shape"), (stack, world, entity, s) -> (float)(System.identityHashCode(stack) % 4) / 3.0f);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModRegistry.SLED.get(), SledEntityRenderer::new);
        event.register(ModRegistry.CONTAINER_ENTITY.get(), ContainerHolderEntityRenderer::new);
        event.register(ModRegistry.GINGERBREAD_GOLEM.get(), c -> new GingyEntityRenderer(c, 1.0f));
        event.register(ModRegistry.GINGERBREAD_GIANT.get(), c -> new GingyEntityRenderer(c, 10.0f));
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(SLED_MODEL, SledModel::createMesh);
        event.register(SLED_MODEL_BAMBOO, SledModel::createBambooMesh);
        event.register(QUILT_MODEL, QuiltModel::createBodyLayer);
        event.register(GINGY_MODEL, GingyModel::createBodyLayer);
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(SnowySpirit.res("glow_lights"), (CustomModelLoader)new NestedModelLoader("overlay", GlowLightsBakedModel::new));
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        event.register((BlockColor)new MimicBlockColor(), (Block[])ModRegistry.GLOW_LIGHTS_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new));
    }

    private static class MimicBlockColor
    implements BlockColor {
        private MimicBlockColor() {
        }

        public int getColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tint) {
            return MimicBlockColor.col(state, world, pos, tint);
        }

        public static int col(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
            GlowLightsBlockTile tile;
            BlockState mimic;
            BlockEntity blockEntity;
            if (level != null && pos != null && (blockEntity = level.getBlockEntity(pos)) instanceof GlowLightsBlockTile && (mimic = (tile = (GlowLightsBlockTile)blockEntity).getHeldBlock()) != null && !mimic.hasBlockEntity()) {
                return Minecraft.getInstance().getBlockColors().getColor(mimic, level, pos, tint);
            }
            return -1;
        }

        public static class NoParticle
        implements BlockColor {
            public int getColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tint) {
                if (tint == 0) {
                    return -1;
                }
                return MimicBlockColor.col(state, world, pos, tint);
            }
        }
    }
}

