/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.neoforge;

import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.entity.GolemHelper;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathHandler;
import net.mehvahdjukaar.snowyspirit.integration.configured.ModConfigSelectScreen;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@Mod(value="snowyspirit")
public class SnowySpiritForge {
    public SnowySpiritForge(IEventBus busEvent) {
        SnowySpirit.commonInit();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientHelper.addClientSetup(() -> {
                if (ModList.get().isLoaded("configured")) {
                    ModConfigSelectScreen.registerConfigScreen((String)"snowyspirit", ModConfigSelectScreen::new);
                }
            });
        }
        NeoForge.EVENT_BUS.register((Object)this);
        PlatHelper.addCommonSetup(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(Utils.getID((Item)ModRegistry.GINGER.get()), ModRegistry.GINGER_POT));
        busEvent.addListener(this::onRegisterCapability);
    }

    public void onRegisterCapability(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, ModRegistry.CONTAINER_ENTITY.get(), (entity, object2) -> new InvWrapper((Container)entity));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult res = WreathHandler.onRightClickBlock(event.getEntity(), event.getLevel(), event.getItemStack(), event.getPos());
        if (res != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(res);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEvent(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WreathHandler.tickEvent(level2);
        }
    }

    @SubscribeEvent
    public void onUseBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getPlacedBlock().getBlock() instanceof CarvedPumpkinBlock) {
            GolemHelper.trySpawningGingy(event.getPlacedBlock(), event.getLevel(), event.getPos(), event.getEntity());
        }
    }
}

