/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.integration.supp;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class PlacePresentTask
extends Behavior<Villager> {
    private final float speedModifier;
    private BlockPos targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public static boolean isPresentOn() {
        return CommonConfigs.isEnabled("present");
    }

    public PlacePresentTask(float speed) {
        super((Map)ImmutableMap.of(ModMemoryModules.PLACED_PRESENT.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.MEETING_POINT, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Villager pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.isBaby()) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason((Level)level)) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)level, (Entity)pOwner) || level.random.nextInt(5) != 0) {
            this.cooldown = 1000;
            return false;
        }
        Optional meeting = pOwner.getBrain().getMemory(MemoryModuleType.MEETING_POINT);
        if (meeting.isEmpty() || level.dimension() != ((GlobalPos)meeting.get()).dimension() || ((GlobalPos)meeting.get()).pos().distSqr((Vec3i)pOwner.blockPosition()) > 225.0) {
            this.cooldown = 400;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (10 + pLevel.random.nextInt(10)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePresentTask.getValidPlacementPos(pLevel, (LivingEntity)pEntity);
        if (this.targetPos != null) {
            pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, this.speedModifier, 1));
            PlacePresentTask.displayAsHeldItem(pEntity, this.getRandomPresent(pLevel.random));
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        PlacePresentTask.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.targetPos != null && PlacePresentTask.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetPos, this.speedModifier, 2));
            pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetPos));
            if (this.targetPos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    ItemStack stack = pOwner.getMainHandItem();
                    Item item = stack.getItem();
                    if (item instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        BlockState state = (BlockState)blockItem.getBlock().defaultBlockState().setValue((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(true));
                        pLevel.setBlockAndUpdate(this.targetPos, state);
                        SoundType soundtype = state.getSoundType();
                        pLevel.playSound(null, this.targetPos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        pOwner.getBrain().setMemory(ModMemoryModules.PLACED_PRESENT.get(), (Object)true);
                        BlockEntity blockEntity = pLevel.getBlockEntity(this.targetPos);
                        if (blockEntity instanceof PresentBlockTile) {
                            PresentBlockTile tile = (PresentBlockTile)blockEntity;
                            tile.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)SnowySpirit.res("chests/present_villager")), pLevel.getRandom().nextLong());
                            tile.setSender(pOwner.getName().getString());
                        }
                    }
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static BlockPos getValidPlacementPos(ServerLevel pLevel, LivingEntity pWalker) {
        RandomSource random = pWalker.getRandom();
        Optional v = pWalker.getBrain().getMemory(MemoryModuleType.MEETING_POINT);
        if (v.isEmpty()) {
            return null;
        }
        BlockPos meeting = ((GlobalPos)v.get()).pos();
        for (int i = 0; i < 6; ++i) {
            BlockPos pos = meeting.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!PlacePresentTask.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(ServerLevel serverLevel, BlockPos pos) {
        BlockState state;
        if (serverLevel.canSeeSky(pos) && (double)serverLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() >= (double)(serverLevel.getSeaLevel() - 10) && (state = serverLevel.getBlockState(pos)).canBeReplaced() && state.getFluidState().isEmpty()) {
            BlockState below = serverLevel.getBlockState(pos.below());
            return below.isFaceSturdy((BlockGetter)serverLevel, pos, Direction.UP) || below.is(BlockTags.DIRT);
        }
        return false;
    }

    public ItemStack getRandomPresent(RandomSource random) {
        return ((Block)((Supplier)ModRegistry.PRESENTS.get(DyeColor.values()[random.nextInt(DyeColor.values().length)])).get()).asItem().getDefaultInstance();
    }

    public static void clearHeldItem(Villager self) {
        self.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.085f);
    }

    public static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.setItemSlot(EquipmentSlot.MAINHAND, stack);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }
}

