/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.integration.configured;

import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigScreen;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ModConfigScreen
extends CustomConfigScreen {
    private static final Map<String, ItemStack> CUSTOM_ICONS = new HashMap<String, ItemStack>();

    public ModConfigScreen(CustomConfigSelectScreen parent, IModConfig config) {
        super(parent, config);
        this.icons.putAll(CUSTOM_ICONS);
    }

    public ModConfigScreen(String modId, ItemStack mainIcon, Component title, Screen parent, IModConfig config) {
        super(modId, mainIcon, title, parent, config);
        this.icons.putAll(CUSTOM_ICONS);
    }

    private static void addIcon(String s, ItemLike i) {
        CUSTOM_ICONS.put(s, i.asItem().getDefaultInstance());
    }

    public void onSave() {
    }

    public CustomConfigScreen.Factory getSubScreenFactory() {
        return ModConfigScreen::new;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && SnowySpirit.isChristmasSeason((Level)level)) {
            int x = (int)((float)this.width * 0.93f);
            graphics.renderFakeItem(Items.SNOWBALL.getDefaultInstance(), x, 16);
            if (ScreenUtil.isMouseWithin((int)x, (int)16, (int)16, (int)16, (int)mouseX, (int)mouseY)) {
                graphics.renderTooltip(this.font, this.font.split((FormattedText)Component.translatable((String)"gui.snowyspirit.snow_season_on").withStyle(ChatFormatting.AQUA), 200), mouseX, mouseY);
            }
        }
    }

    static {
        ModConfigScreen.addIcon("sleds", (ItemLike)ModRegistry.SLED_ITEMS.get(VanillaWoodTypes.OAK));
        ModConfigScreen.addIcon("gumdrops", (ItemLike)ModRegistry.GUMDROPS_BUTTONS.get(DyeColor.GREEN).get().asItem());
        ModConfigScreen.addIcon("glow lights", (ItemLike)ModRegistry.GLOW_LIGHTS_ITEMS.get(null).get().asItem());
        ModConfigScreen.addIcon("blocks and items", (ItemLike)ModRegistry.CANDY_CANE_BLOCK.get());
        ModConfigScreen.addIcon("snowy season", (ItemLike)ModRegistry.SNOW_GLOBE.get());
        ModConfigScreen.addIcon("misc", (ItemLike)ModRegistry.GINGERBREAD_COOKIE.get());
        ModConfigScreen.addIcon("friction", (ItemLike)Items.SNOW_BLOCK);
        ModConfigScreen.addIcon("steering", (ItemLike)Items.LEAD);
        ModConfigScreen.addIcon("particles", (ItemLike)ModRegistry.GLOW_LIGHTS_ITEMS.get(null).get().asItem());
    }
}

