/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import java.util.ArrayList;
import java.util.Iterator;
import net.mehvahdjukaar.snowyspirit.common.wreath.ChunksWithWreaths;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathData;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public class WreathHandler {
    public static boolean placeWreathOnDoor(BlockPos pos, Level level) {
        BlockState door;
        WreathData wreathData = WreathData.getAt(level, pos);
        if (wreathData != null && (door = level.getBlockState(pos)).getBlock() instanceof DoorBlock) {
            BlockPos p;
            boolean lower = door.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER;
            BlockPos blockPos = p = lower ? pos.above() : pos;
            if (!wreathData.hasWreathAt(p)) {
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    BlockState state = ModRegistry.WREATH.get().defaultBlockState();
                    wreathData.setWreath(p, level);
                    wreathData.markDirty(p, sl);
                    SoundType soundtype = state.getSoundType();
                    level.playSound(null, p, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                }
                return true;
            }
        }
        return false;
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, ItemStack stack, BlockPos pos) {
        if (stack.is(ModRegistry.WREATH.get().asItem()) && WreathHandler.placeWreathOnDoor(pos, level)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static void tickEvent(ServerLevel level) {
        ChunksWithWreaths data = (ChunksWithWreaths)ModRegistry.WREATH_WORLD_DATA.getData((Level)level);
        Iterator chunks = data.getLoadedChunks(level).iterator();
        while (chunks.hasNext()) {
            ChunkAccess chunk = (ChunkAccess)chunks.next();
            WreathData c = (WreathData)ModRegistry.WREATH_CHUNK_DATA.getOrNull((Object)chunk);
            if (c == null) continue;
            boolean changed = false;
            for (BlockPos p : new ArrayList<BlockPos>(c.getWreathBlocks())) {
                BlockState state = level.getBlockState(p);
                if (state.getBlock() instanceof DoorBlock) continue;
                c.removeWreath(p, (Level)level, true);
                changed = true;
            }
            if (!changed) continue;
            c.markDirty(chunk.getPos().getWorldPosition(), level);
        }
    }
}

