/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.snowyspirit.common.network.ClientBoundMarkPosForRebuildMessage;
import net.mehvahdjukaar.snowyspirit.common.wreath.ChunksWithWreaths;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WreathData {
    public static final Codec<WreathData> CODEC = BlockPos.CODEC.listOf().xmap(list -> {
        WreathData data = new WreathData();
        data.wreathBlocks.addAll((Collection<BlockPos>)list);
        return data;
    }, d -> d.wreathBlocks.stream().toList());
    public static final StreamCodec<ByteBuf, WreathData> STREAM_CODEC = BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()).map(l -> {
        WreathData data = new WreathData();
        data.wreathBlocks.addAll((Collection<BlockPos>)l);
        return data;
    }, w -> w.wreathBlocks.stream().toList());
    private final Set<BlockPos> wreathBlocks = new HashSet<BlockPos>();

    public static WreathData getAt(Level level, BlockPos pos) {
        return (WreathData)ModRegistry.WREATH_CHUNK_DATA.getOrCreate((Object)level.getChunkAt(pos));
    }

    public void setWreath(BlockPos pos, Level level) {
        this.wreathBlocks.add(pos);
    }

    public void removeWreath(BlockPos p, Level level, boolean animationAndDrop) {
        this.wreathBlocks.remove(p);
        if (animationAndDrop) {
            ItemEntity itementity = new ItemEntity(level, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, ModRegistry.WREATH.get().asItem().getDefaultInstance());
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            level.levelEvent(2001, p, Block.getId((BlockState)ModRegistry.WREATH.get().defaultBlockState()));
        }
    }

    public Set<BlockPos> getWreathBlocks() {
        return this.wreathBlocks;
    }

    public boolean isEmpty() {
        return this.wreathBlocks.isEmpty();
    }

    public boolean hasWreathAt(BlockPos p) {
        return this.wreathBlocks.contains(p);
    }

    public void markDirty(BlockPos pos, ServerLevel level) {
        level.getChunkAt(pos).setUnsaved(true);
        ModRegistry.WREATH_CHUNK_DATA.sync((Object)level.getChunkAt(pos));
        NetworkHelper.sendToAllClientPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new ClientBoundMarkPosForRebuildMessage(pos));
        ((ChunksWithWreaths)ModRegistry.WREATH_WORLD_DATA.getData((Level)level)).updateStatus(new ChunkPos(pos), this.wreathBlocks.isEmpty());
    }

    public boolean hasWreathsInSection(int minY, int maxY) {
        for (BlockPos pos : this.wreathBlocks) {
            if (pos.getY() < minY || pos.getY() >= maxY) continue;
            return true;
        }
        return false;
    }
}

