/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ThrowSnowballsTask
extends Behavior<Villager> {
    private int cooldownBetweenAttacks;
    private int eggs;
    private final int maxRange;
    private int duration = 400;
    private int cooldown = 0;

    public ThrowSnowballsTask(int range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_PRESENT));
        this.maxRange = range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason((Level)pLevel)) {
            return false;
        }
        LivingEntity livingentity = this.getLookTarget((LivingEntity)pOwner);
        if (livingentity == null) {
            return false;
        }
        return BehaviorUtils.canSee((LivingEntity)pOwner, (LivingEntity)livingentity) && livingentity.distanceToSqr(pOwner.getX(), pOwner.getY(), pOwner.getZ()) < (double)(this.maxRange * this.maxRange);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (this.duration <= 0) {
            return false;
        }
        return this.eggs == 0 || this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity livingentity = this.getLookTarget((LivingEntity)pEntity);
        pEntity.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)livingentity);
        ThrowSnowballsTask.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.SNOWBALL));
        if (this.eggs == 0) {
            this.duration = 400;
            this.eggs = pLevel.random.nextInt(3) + 1;
            this.cooldownBetweenAttacks = 35 + pLevel.random.nextInt(30);
        }
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = pOwner.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).orElse(null);
        if (target == null) {
            return;
        }
        BehaviorUtils.lookAtEntity((LivingEntity)pOwner, (LivingEntity)target);
        if (this.cooldownBetweenAttacks-- == 0) {
            this.cooldownBetweenAttacks = 20 + pLevel.random.nextInt(30);
            --this.eggs;
            Snowball egg = new Snowball((Level)pLevel, (LivingEntity)pOwner);
            double d0 = target.getY() - 0.5;
            double d1 = target.getX() - pOwner.getX();
            double d2 = d0 - egg.getY();
            double d3 = target.getZ() - pOwner.getZ();
            double distFactor = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            egg.shoot(d1, (d2 + distFactor) * 0.5, d3, 1.1f, 8.0f);
            pLevel.playSound(null, pOwner.getX(), pOwner.getY(), pOwner.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            pLevel.addFreshEntity((Entity)egg);
        }
        if (this.eggs <= 0) {
            this.cooldown = 20 * (10 + pLevel.random.nextInt(15)) + pLevel.random.nextInt(20);
        }
        --this.duration;
    }

    public static void clearInteractionTarget(Villager pOwner) {
        pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        ThrowSnowballsTask.displayAsHeldItem(pOwner, ItemStack.EMPTY);
    }

    private static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.setItemSlot(EquipmentSlot.MAINHAND, stack);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        ThrowSnowballsTask.clearInteractionTarget(pEntity);
    }

    @Nullable
    private LivingEntity getLookTarget(LivingEntity pMob) {
        EntityTracker entityTracker;
        Entity e;
        PositionTracker v = pMob.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).orElse(null);
        if (v instanceof EntityTracker && (e = (entityTracker = (EntityTracker)v).getEntity()) instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)e;
            return entity;
        }
        return null;
    }
}

