/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit;

import java.util.Calendar;
import java.util.Date;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.snowyspirit.common.network.ModNetworking;
import net.mehvahdjukaar.snowyspirit.configs.ClientConfigs;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.snowyspirit.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.snowyspirit.integration.FDCompat;
import net.mehvahdjukaar.snowyspirit.integration.SeasonModCompat;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModCreativeTabs;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModSetup;
import net.mehvahdjukaar.snowyspirit.reg.ModSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnowySpirit {
    public static final String MOD_ID = "snowyspirit";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean SUPPLEMENTARIES_INSTALLED = PlatHelper.isModLoaded((String)"supplementaries");
    public static final boolean FARMERSDELIGHT_INSTALLED = PlatHelper.isModLoaded((String)"farmersdelight");
    public static final boolean SEASON_MOD_INSTALLED = PlatHelper.isModLoaded((String)(PlatHelper.getPlatform().isForge() ? "sereneseasons" : "seasons"));
    public static final boolean BOATLOAD_INSTALLED = PlatHelper.isModLoaded((String)"boatload");
    public static boolean IS_CHRISTMAS_REAL_TIME;
    public static boolean USES_SEASON_MOD;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)ServerDynamicResourcesHandler.INSTANCE);
        ModNetworking.init();
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)SnowySpirit.res("flag"), CommonConfigs::isEnabled);
        ModSounds.init();
        ModRegistry.init();
        ModMemoryModules.init();
        ModCreativeTabs.init();
        if (FARMERSDELIGHT_INSTALLED) {
            FDCompat.init();
        }
        PlatHelper.addCommonSetup(ModSetup::setup);
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)ClientDynamicResourcesHandler.INSTANCE);
            ClientRegistry.init();
            ClientHelper.addClientSetup(ClientRegistry::setup);
        }
        RegHelper.addLootTableInjects(SnowySpirit::injectLootPools);
    }

    private static void injectLootPools(RegHelper.LootInjectEvent event) {
        String table = event.getTable().toString();
        if (table.equals("minecraft:gameplay/sniffer_digging")) {
            event.addTableReference(SnowySpirit.res("injects/ginger_sniffer"));
        }
    }

    public static void onConfigReload() {
        int startM = CommonConfigs.START_MONTH.get() - 1;
        int startD = CommonConfigs.START_DAY.get();
        int endM = CommonConfigs.END_MONTH.get() - 1;
        int endD = CommonConfigs.END_DAY.get();
        boolean inv = startM > endM;
        Date start = new Date(0, startM, startD);
        Date end = new Date(inv ? 1 : 0, endM, endD);
        Date today = new Date(0, Calendar.getInstance().get(2), Calendar.getInstance().get(5));
        if (today.before(start) && inv) {
            today = new Date(1, today.getMonth(), today.getDate());
        }
        IS_CHRISTMAS_REAL_TIME = SnowySpirit.after(today, start) && SnowySpirit.before(today, end);
        boolean bl = USES_SEASON_MOD = SEASON_MOD_INSTALLED && CommonConfigs.SEASONS_MOD_COMPAT.get() != false;
        if (USES_SEASON_MOD) {
            SeasonModCompat.refresh();
        }
    }

    public static boolean before(Date obj, Date that) {
        int objYear = obj.getYear();
        int thatYear = that.getYear();
        int objMonth = obj.getMonth();
        int thatMonth = that.getMonth();
        int objDay = obj.getDate();
        int thatDay = that.getDate();
        if (objYear < thatYear) {
            return true;
        }
        if (objYear > thatYear) {
            return false;
        }
        if (objMonth < thatMonth) {
            return true;
        }
        if (objMonth > thatMonth) {
            return false;
        }
        return objDay < thatDay;
    }

    public static boolean after(Date obj, Date that) {
        return !SnowySpirit.before(obj, that) && !obj.equals(that);
    }

    public static boolean isChristmasSeason(Level level) {
        if (USES_SEASON_MOD) {
            return SeasonModCompat.isWinter(level);
        }
        return IS_CHRISTMAS_REAL_TIME;
    }
}

