/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StarbyItemBehavior
extends StarbyListBehavior {
    public ItemStack itemScroll = ItemStack.EMPTY;

    public StarbyItemBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        this.itemScroll = ItemStack.parseOptional((HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)tag.getCompound("itemScroll"));
    }

    @Nullable
    public IItemHandler getItemCapFromTile(BlockPos pos, @Nullable Direction face) {
        return (IItemHandler)this.starbuncle.level().getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face);
    }

    public ItemScroll.SortPref canDepositItem(BlockPos pos, ItemStack stack) {
        ItemScroll scrollItem;
        Item item;
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (pos == null || stack == null || stack.isEmpty()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = this.getItemCapFromTile(pos, (Direction)this.TO_DIRECTION_MAP.get(pos.hashCode()));
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrame i : this.level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            BlockEntity adjTile = this.level.getBlockEntity(i.blockPosition().relative(i.getDirection().getOpposite()));
            if (adjTile == null || !adjTile.equals(this.level.getBlockEntity(pos)) || i.getItem().isEmpty()) continue;
            ItemStack stackInFrame = i.getItem();
            Item item2 = stackInFrame.getItem();
            if (item2 instanceof ItemScroll) {
                ItemScroll scrollItem2 = (ItemScroll)item2;
                pref = scrollItem2.getSortPref(stack, stackInFrame, handler);
                continue;
            }
            if (i.getItem().getItem() != stack.getItem()) {
                return ItemScroll.SortPref.INVALID;
            }
            if (i.getItem().getItem() != stack.getItem()) continue;
            pref = ItemScroll.SortPref.HIGHEST;
        }
        if (this.itemScroll != null && (item = this.itemScroll.getItem()) instanceof ItemScroll && (scrollItem = (ItemScroll)item).getSortPref(stack, this.itemScroll, handler) == ItemScroll.SortPref.INVALID) {
            return ItemScroll.SortPref.INVALID;
        }
        return !ItemStack.matches((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    public ItemScroll.SortPref sortPrefForStack(@Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.isEmpty() || b == null || !this.level.isLoaded(b)) {
            return ItemScroll.SortPref.INVALID;
        }
        return this.canDepositItem(b, stack);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof ItemScroll) {
            ItemScroll scroll = (ItemScroll)item;
            this.itemScroll = stack.copy();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        if (this.TO_LIST.isEmpty() || stack.isEmpty()) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : this.TO_LIST) {
            ItemScroll.SortPref pref = this.sortPrefForStack(b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
            if (foundPref != ItemScroll.SortPref.HIGHEST) continue;
            return returnPos;
        }
        return returnPos;
    }

    @Nullable
    public BlockPos getValidTakePos() {
        if (this.FROM_LIST.isEmpty()) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidTake(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        Direction face = (Direction)this.FROM_DIRECTION_MAP.get(p.hashCode());
        IItemHandler iItemHandler = this.getItemCapFromTile(p, face);
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || this.getValidStorePos(stack) == null) continue;
            return true;
        }
        return false;
    }

    public int getMaxTake(ItemStack stack) {
        return stack.getMaxStackSize();
    }
}

