/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.underground_village.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.reggarf.mods.underground_village.CommonClass;
import com.reggarf.mods.underground_village.register.USRegistryAccess;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class UndergroundStructure
extends Structure {
    public static final MapCodec<UndergroundStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UndergroundStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(s -> s.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(s -> s.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(s -> s.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(s -> s.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(s -> s.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(s -> CommonClass.CONFIG.maxDistanceFromCenter), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(s -> s.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.IGNORE_WATERLOGGING).forGetter(s -> s.liquidSettings)).apply((Applicative)instance, UndergroundStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public UndergroundStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int ignoredMaxDistance, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = CommonClass.CONFIG.structureSize;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = CommonClass.CONFIG.maxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        int surfaceY = context.chunkGenerator().getFirstFreeHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        return surfaceY > 40 && surfaceY < 100;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!UndergroundStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), startY, chunkPos.getMinBlockZ());
        int actualSize = CommonClass.CONFIG.structureSize;
        int actualMaxDistance = CommonClass.CONFIG.maxDistanceFromCenter;
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)actualSize, (BlockPos)blockPos, (boolean)true, this.projectStartToHeightmap, (int)actualMaxDistance, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    public StructureType<?> type() {
        return USRegistryAccess.STRUCTURES.underground();
    }
}

