/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.outline;

import com.heaser.pipeconnector.client.outline.PipeConnectorRenderType;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.utils.BuildParameters;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.PreviewInfo;
import com.heaser.pipeconnector.utils.TagUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PreviewDrawer {
    public HashSet<PreviewInfo> previewMap = new HashSet();
    private BuildParameters cachedParameters = new BuildParameters();
    private static final double PIPE_HALF = 0.075;
    private static final double NODE_HALF = 0.2;

    public void handleOnRenderLevel(PoseStack pose, MultiBufferSource buffer, Player player) {
        ItemStack heldItem = GeneralUtils.heldPipeConnector(player);
        if (heldItem == null) {
            return;
        }
        if (this.shouldUpdatePreview(heldItem)) {
            Level currentLevel = player.level();
            this.previewMap = this.getNewPreview(heldItem, currentLevel, player);
        }
        this.draw(pose, buffer, player, heldItem);
    }

    private HashSet<PreviewInfo> getNewPreview(ItemStack pipeConnector, Level currentLevel, Player player) {
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        if (nodes.size() < 2) {
            return new HashSet<PreviewInfo>();
        }
        int depth = TagUtils.getDepthFromStack(pipeConnector);
        boolean utilizeExitingPipes = TagUtils.getUtilizeExistingPipes(pipeConnector);
        return PipeConnectorUtils.getBlockPosSet(PipeConnectorUtils.getBlockPosMap(nodes, depth, currentLevel, TagUtils.getBridgeType(pipeConnector), CompatibilityBlockGetter.getInstance().getBlock(player.getOffhandItem()), player.getOffhandItem(), utilizeExitingPipes, player));
    }

    private void draw(PoseStack pose, MultiBufferSource buffer, Player player, ItemStack pipeConnector) {
        Vec3 offset = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        List<BlockPos> nodePositions = nodes.stream().map(NodeParameter::getRelativePosition).toList();
        HashSet<BlockPos> nodeSet = new HashSet<BlockPos>(nodePositions);
        HashSet<BlockPos> previewPositions = new HashSet<BlockPos>();
        for (PreviewInfo pi : this.previewMap) {
            previewPositions.add(pi.pos);
        }
        long time = System.currentTimeMillis();
        float pulseAlpha = (float)(Math.sin((double)time / 250.0) * 0.15 + 0.75);
        float pulseScale = (float)(Math.sin((double)time / 250.0) * 0.02 + 1.0);
        boolean solid = TagUtils.getSolidPreview(pipeConnector);
        for (PreviewInfo previewInfo : this.previewMap) {
            BlockPos pos = previewInfo.pos;
            float[] color = this.getColorForPos(player, pos);
            color[3] = color[3] * pulseAlpha;
            int nodeIdx = nodePositions.indexOf(pos);
            boolean isNode = nodeIdx >= 0;
            float[] nodeColor = null;
            if (isNode) {
                nodeColor = nodeIdx == 0 ? new float[]{0.0f, 1.0f, 1.0f, 1.0f} : (nodeIdx == nodePositions.size() - 1 ? new float[]{1.0f, 0.65f, 0.0f, 1.0f} : this.argbToRgba(this.getIndexColor(nodeIdx)));
                nodeColor[3] = Math.min(1.0f, nodeColor[3] * (pulseAlpha + 0.2f));
            }
            this.drawPipePiece(pose, buffer, pos, offset, previewPositions, color, isNode, nodeColor, solid, pulseScale);
        }
        for (int i = 0; i < nodePositions.size(); ++i) {
            int nodeColorInt = i == 0 ? -16711681 : (i == nodePositions.size() - 1 ? -23296 : this.getIndexColor(i));
            this.renderNodeIndexNumber(pose, buffer, nodePositions.get(i), i + 1, offset, nodeColorInt);
        }
    }

    private void renderNodeIndexNumber(PoseStack pose, MultiBufferSource buffer, BlockPos pos, int index, Vec3 cameraOffset, int color) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        String label = Component.translatable((String)"item.pipe_connector.preview.position").getString();
        String number = Integer.toString(index);
        pose.pushPose();
        double x = (double)pos.getX() + 0.5 - cameraOffset.x;
        double y = (double)pos.getY() + 0.75 - cameraOffset.y;
        double z = (double)pos.getZ() + 0.5 - cameraOffset.z;
        pose.translate(x, y, z);
        pose.mulPose(mc.gameRenderer.getMainCamera().rotation());
        float scale = 0.04f;
        pose.scale(scale, -scale, scale);
        pose.translate(0.0, 0.0, 0.01);
        float labelWidth = font.width(label);
        float numberWidth = font.width(number);
        int white = -1;
        pose.pushPose();
        pose.translate(0.0, 0.0, -0.001);
        float f = -labelWidth / 2.0f;
        Objects.requireNonNull(font);
        font.drawInBatch(label, f, (float)(-9), -16777216, true, pose.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.popPose();
        float f2 = -labelWidth / 2.0f;
        Objects.requireNonNull(font);
        font.drawInBatch(label, f2, (float)(-9), white, false, pose.last().pose(), buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        int textColor = -1;
        pose.pushPose();
        pose.translate(0.0, 0.0, -0.001);
        font.drawInBatch(number, -numberWidth / 2.0f, 0.0f, -16777216, true, pose.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.popPose();
        font.drawInBatch(number, -numberWidth / 2.0f, 0.0f, textColor, false, pose.last().pose(), buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        pose.popPose();
    }

    private float[] getColorForPos(Player player, BlockPos pos) {
        if (GeneralUtils.isNotBreakable(player.level(), pos) || GeneralUtils.hasInventoryCapabilities(player.level(), pos)) {
            return new float[]{1.0f, 0.2f, 0.2f, 1.0f};
        }
        if (GeneralUtils.isVoidableBlock(player.level(), pos)) {
            return new float[]{1.0f, 0.9f, 0.1f, 1.0f};
        }
        CompatibilityBlockEqualsChecker.getInstance();
        if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(pos, CompatibilityBlockGetter.getInstance().getBlock(player.getOffhandItem()), player.getOffhandItem(), player.level())) {
            return new float[]{0.9f, 0.4f, 1.0f, 0.5f};
        }
        return new float[]{0.2f, 1.0f, 0.2f, 0.5f};
    }

    private void drawPipePiece(PoseStack pose, MultiBufferSource buffer, BlockPos pos, Vec3 offset, Set<BlockPos> previewPositions, float[] rgba, boolean isNode, float[] nodeRgba, boolean solid, float pulseScale) {
        float[] drawColor;
        double cx = (double)pos.getX() + 0.5;
        double cy = (double)pos.getY() + 0.5;
        double cz = (double)pos.getZ() + 0.5;
        double baseHalf = isNode ? 0.2 : 0.075;
        double half = baseHalf * (double)pulseScale;
        float[] fArray = drawColor = isNode && nodeRgba != null ? nodeRgba : rgba;
        if (solid) {
            if (isNode) {
                this.drawShadedBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, cz - half - offset.z, cx + half - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            } else {
                this.drawFilledBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, cz - half - offset.z, cx + half - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            }
        } else {
            this.drawWireBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, cz - half - offset.z, cx + half - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
        }
        if (previewPositions.contains(pos.relative(Direction.WEST))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, (double)pos.getX() - offset.x, cy - half - offset.y, cz - half - offset.z, cx - half - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, (double)pos.getX() - offset.x, cy - half - offset.y, cz - half - offset.z, cx - half - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            }
        }
        if (previewPositions.contains(pos.relative(Direction.EAST))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, cx + half - offset.x, cy - half - offset.y, cz - half - offset.z, (double)pos.getX() + 1.0 - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, cx + half - offset.x, cy - half - offset.y, cz - half - offset.z, (double)pos.getX() + 1.0 - offset.x, cy + half - offset.y, cz + half - offset.z, drawColor);
            }
        }
        if (previewPositions.contains(pos.relative(Direction.NORTH))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, (double)pos.getZ() - offset.z, cx + half - offset.x, cy + half - offset.y, cz - half - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, (double)pos.getZ() - offset.z, cx + half - offset.x, cy + half - offset.y, cz - half - offset.z, drawColor);
            }
        }
        if (previewPositions.contains(pos.relative(Direction.SOUTH))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, cz + half - offset.z, cx + half - offset.x, cy + half - offset.y, (double)pos.getZ() + 1.0 - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, cx - half - offset.x, cy - half - offset.y, cz + half - offset.z, cx + half - offset.x, cy + half - offset.y, (double)pos.getZ() + 1.0 - offset.z, drawColor);
            }
        }
        if (previewPositions.contains(pos.relative(Direction.DOWN))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, cx - half - offset.x, (double)pos.getY() - offset.y, cz - half - offset.z, cx + half - offset.x, cy - half - offset.y, cz + half - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, cx - half - offset.x, (double)pos.getY() - offset.y, cz - half - offset.z, cx + half - offset.x, cy - half - offset.y, cz + half - offset.z, drawColor);
            }
        }
        if (previewPositions.contains(pos.relative(Direction.UP))) {
            if (solid) {
                this.drawFilledBox(pose, buffer, cx - half - offset.x, cy + half - offset.y, cz - half - offset.z, cx + half - offset.x, (double)pos.getY() + 1.0 - offset.y, cz + half - offset.z, drawColor);
            } else {
                this.drawWireBox(pose, buffer, cx - half - offset.x, cy + half - offset.y, cz - half - offset.z, cx + half - offset.x, (double)pos.getY() + 1.0 - offset.y, cz + half - offset.z, drawColor);
            }
        }
    }

    private void drawFilledBox(PoseStack pose, MultiBufferSource buffer, double x0, double y0, double z0, double x1, double y1, double z1, float[] rgba) {
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        VertexConsumer vc = buffer.getBuffer(PipeConnectorRenderType.QUADS_NO_DEPTH_TEST);
        Matrix4f mat = pose.last().pose();
        float X0 = (float)Math.min(x0, x1);
        float Y0 = (float)Math.min(y0, y1);
        float Z0 = (float)Math.min(z0, z1);
        float X1 = (float)Math.max(x0, x1);
        float Y1 = (float)Math.max(y0, y1);
        float Z1 = (float)Math.max(z0, z1);
        this.v(vc, mat, X0, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X0, Y0, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y0, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y0, Z0, r, g, b, a);
        this.v(vc, mat, X0, Y0, Z1, r, g, b, a);
        this.v(vc, mat, X0, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y1, Z1, r, g, b, a);
        this.v(vc, mat, X1, Y0, Z1, r, g, b, a);
    }

    private void drawShadedBox(PoseStack pose, MultiBufferSource buffer, double x0, double y0, double z0, double x1, double y1, double z1, float[] rgba) {
        Matrix4f mat = pose.last().pose();
        VertexConsumer vc = buffer.getBuffer(PipeConnectorRenderType.QUADS_NO_DEPTH_TEST);
        float X0 = (float)Math.min(x0, x1);
        float Y0 = (float)Math.min(y0, y1);
        float Z0 = (float)Math.min(z0, z1);
        float X1 = (float)Math.max(x0, x1);
        float Y1 = (float)Math.max(y0, y1);
        float Z1 = (float)Math.max(z0, z1);
        Vector3f sun = new Vector3f(-0.35f, 0.9f, -0.25f).normalize();
        Vector3f[] normals = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        float[] m = new float[6];
        for (int i = 0; i < 6; ++i) {
            float dot = Math.max(0.0f, normals[i].dot((Vector3fc)sun));
            m[i] = 0.45f + dot * 0.55f;
        }
        m[3] = Math.min(1.15f, m[3] + 0.15f);
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        this.v(vc, mat, X0, Y0, Z0, r * m[0], g * m[0], b * m[0], a);
        this.v(vc, mat, X0, Y1, Z0, r * m[0], g * m[0], b * m[0], a);
        this.v(vc, mat, X0, Y1, Z1, r * m[0], g * m[0], b * m[0], a);
        this.v(vc, mat, X0, Y0, Z1, r * m[0], g * m[0], b * m[0], a);
        this.v(vc, mat, X1, Y0, Z1, r * m[1], g * m[1], b * m[1], a);
        this.v(vc, mat, X1, Y1, Z1, r * m[1], g * m[1], b * m[1], a);
        this.v(vc, mat, X1, Y1, Z0, r * m[1], g * m[1], b * m[1], a);
        this.v(vc, mat, X1, Y0, Z0, r * m[1], g * m[1], b * m[1], a);
        this.v(vc, mat, X0, Y0, Z1, r * m[2], g * m[2], b * m[2], a);
        this.v(vc, mat, X1, Y0, Z1, r * m[2], g * m[2], b * m[2], a);
        this.v(vc, mat, X1, Y0, Z0, r * m[2], g * m[2], b * m[2], a);
        this.v(vc, mat, X0, Y0, Z0, r * m[2], g * m[2], b * m[2], a);
        this.v(vc, mat, X0, Y1, Z0, r * m[3], g * m[3], b * m[3], a);
        this.v(vc, mat, X1, Y1, Z0, r * m[3], g * m[3], b * m[3], a);
        this.v(vc, mat, X1, Y1, Z1, r * m[3], g * m[3], b * m[3], a);
        this.v(vc, mat, X0, Y1, Z1, r * m[3], g * m[3], b * m[3], a);
        this.v(vc, mat, X1, Y0, Z0, r * m[4], g * m[4], b * m[4], a);
        this.v(vc, mat, X1, Y1, Z0, r * m[4], g * m[4], b * m[4], a);
        this.v(vc, mat, X0, Y1, Z0, r * m[4], g * m[4], b * m[4], a);
        this.v(vc, mat, X0, Y0, Z0, r * m[4], g * m[4], b * m[4], a);
        this.v(vc, mat, X0, Y0, Z1, r * m[5], g * m[5], b * m[5], a);
        this.v(vc, mat, X0, Y1, Z1, r * m[5], g * m[5], b * m[5], a);
        this.v(vc, mat, X1, Y1, Z1, r * m[5], g * m[5], b * m[5], a);
        this.v(vc, mat, X1, Y0, Z1, r * m[5], g * m[5], b * m[5], a);
        float inset = 0.12f;
        float eps = 6.0E-4f;
        float hx0 = X0 + inset;
        float hz0 = Z0 + inset;
        float hx1 = X1 - inset;
        float hz1 = Z1 - inset;
        float hr = Math.min(1.0f, r * 1.2f);
        float hg = Math.min(1.0f, g * 1.2f);
        float hb = Math.min(1.0f, b * 1.2f);
        float ha = Math.min(1.0f, a * 0.8f);
        this.v(vc, mat, hx0, Y1 + eps, hz0, hr, hg, hb, ha);
        this.v(vc, mat, hx1, Y1 + eps, hz0, hr, hg, hb, ha);
        this.v(vc, mat, hx1, Y1 + eps, hz1, hr, hg, hb, ha);
        this.v(vc, mat, hx0, Y1 + eps, hz1, hr, hg, hb, ha);
        VertexConsumer lineVC = buffer.getBuffer(PipeConnectorRenderType.THIN_LINES_NO_DEPTH_TEST);
        double epsOutline = 0.0015;
        AABB aabb = new AABB((double)(X0 - (float)epsOutline), (double)(Y0 - (float)epsOutline), (double)(Z0 - (float)epsOutline), (double)(X1 + (float)epsOutline), (double)(Y1 + (float)epsOutline), (double)(Z1 + (float)epsOutline));
        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)lineVC, (AABB)aabb, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void drawWireBox(PoseStack pose, MultiBufferSource buffer, double x0, double y0, double z0, double x1, double y1, double z1, float[] rgba) {
        VertexConsumer builder = buffer.getBuffer(PipeConnectorRenderType.LINES_NO_DEPTH_TEST);
        AABB aabb = new AABB(Math.min(x0, x1), Math.min(y0, y1), Math.min(z0, z1), Math.max(x0, x1), Math.max(y0, y1), Math.max(z0, z1));
        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
    }

    private void v(VertexConsumer vc, Matrix4f mat, float x, float y, float z, float r, float g, float b, float a) {
        Vector4f tv = new Vector4f(x, y, z, 1.0f).mul((Matrix4fc)mat);
        int ri = Math.min(255, Math.max(0, (int)(r * 255.0f)));
        int gi = Math.min(255, Math.max(0, (int)(g * 255.0f)));
        int bi = Math.min(255, Math.max(0, (int)(b * 255.0f)));
        int ai = Math.min(255, Math.max(0, (int)(a * 255.0f)));
        int color = ai << 24 | ri << 16 | gi << 8 | bi;
        vc.addVertex(tv.x, tv.y, tv.z, color, 0.0f, 0.0f, 0, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }

    private float[] argbToRgba(int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        return new float[]{r, g, b, Math.max(a, 1.0f)};
    }

    private int getIndexColor(int zeroBasedIndex) {
        int[] palette = new int[]{-1, -65281, -256, -8388864, -16711809, -8689426, -38476, -5374161};
        return palette[zeroBasedIndex % palette.length];
    }

    private boolean shouldUpdatePreview(ItemStack pipeConnector) {
        boolean shouldUpdate = false;
        BuildParameters newParameters = new BuildParameters(pipeConnector);
        if (!this.cachedParameters.equals(newParameters)) {
            shouldUpdate = true;
            this.cachedParameters = newParameters;
        }
        return shouldUpdate;
    }
}

