/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tools;

import edivad.solargeneration.SolarGeneration;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;

public enum SolarPanelLevel {
    LEADSTONE,
    HARDENED,
    REDSTONE,
    SIGNALUM,
    RESONANT,
    ADVANCED,
    ULTIMATE;


    public String getSolarPanelName() {
        return "solar_panel_" + this.getCorrectName();
    }

    public String getSolarHelmetName() {
        return "solar_helmet_" + this.getCorrectName();
    }

    public String getSolarCoreName() {
        return "solar_core_" + this.getCorrectName();
    }

    public ResourceLocation getArmorTexture() {
        return SolarGeneration.rl("textures/model/armor/solar_helmet_" + this.getCorrectName() + ".png");
    }

    public Holder<ArmorMaterial> getArmorMaterial() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> ArmorMaterials.IRON;
            case 2, 3, 4, 5 -> ArmorMaterials.DIAMOND;
            case 6 -> ArmorMaterials.NETHERITE;
        };
    }

    public int getEnergyGeneration() {
        return (int)Math.pow(8.0, this.ordinal());
    }

    public int getMaxTransfer() {
        return this.getEnergyGeneration() * 2;
    }

    public int getCapacity() {
        return this.getEnergyGeneration() * 1000;
    }

    private String getCorrectName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

