/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.setup;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.blocks.SolarPanelBlock;
import edivad.solargeneration.items.SolarHelmet;
import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registration {
    public static final Map<SolarPanelLevel, DeferredBlock<SolarPanelBlock>> SOLAR_PANEL_BLOCK = new HashMap<SolarPanelLevel, DeferredBlock<SolarPanelBlock>>();
    public static final Map<SolarPanelLevel, DeferredItem<BlockItem>> SOLAR_PANEL_ITEM = new HashMap<SolarPanelLevel, DeferredItem<BlockItem>>();
    public static final Map<SolarPanelLevel, DeferredHolder<BlockEntityType<?>, BlockEntityType<SolarPanelBlockEntity>>> SOLAR_PANEL_BLOCK_ENTITY = new HashMap();
    public static final Map<SolarPanelLevel, DeferredHolder<MenuType<?>, MenuType<SolarPanelMenu>>> SOLAR_PANEL_MENU = new HashMap();
    public static final Map<SolarPanelLevel, DeferredItem<Item>> HELMET = new HashMap<SolarPanelLevel, DeferredItem<Item>>();
    public static final Map<SolarPanelLevel, DeferredItem<Item>> CORE = new HashMap<SolarPanelLevel, DeferredItem<Item>>();
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"solargeneration");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"solargeneration");
    public static final DeferredItem<Item> LAPIS_SHARD = ITEMS.registerSimpleItem("lapis_shard");
    public static final DeferredItem<Item> PHOTOVOLTAIC_CELL = ITEMS.registerSimpleItem("photovoltaic_cell");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"solargeneration");
    private static final DeferredRegister<MenuType<?>> MENU = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"solargeneration");

    public static void register(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MENU.register(modEventBus);
    }

    static {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SOLAR_PANEL_BLOCK.put(level, (DeferredBlock<SolarPanelBlock>)BLOCKS.register(level.getSolarPanelName(), () -> new SolarPanelBlock(level, BlockBehaviour.Properties.of().sound(SoundType.METAL).requiresCorrectToolForDrops().strength(1.5f, 6.0f))));
            SOLAR_PANEL_ITEM.put(level, (DeferredItem<BlockItem>)ITEMS.registerItem(level.getSolarPanelName(), properties -> new BlockItem((Block)SOLAR_PANEL_BLOCK.get((Object)level).get(), properties.component(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)0))));
            SOLAR_PANEL_BLOCK_ENTITY.put(level, BLOCK_ENTITIES.register(level.getSolarPanelName(), () -> BlockEntityType.Builder.of((pos, state) -> new SolarPanelBlockEntity(level, pos, state), (Block[])new Block[]{(Block)SOLAR_PANEL_BLOCK.get((Object)level).get()}).build(null)));
            SOLAR_PANEL_MENU.put(level, MENU.register(level.getSolarPanelName(), () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)(id, inventory, buf) -> {
                BlockPos pos = buf.readBlockPos();
                BlockEntity blockEntity = inventory.player.getCommandSenderWorld().getBlockEntity(pos);
                if (!(blockEntity instanceof SolarPanelBlockEntity)) {
                    SolarGeneration.LOGGER.error("Wrong type of block entity (expected SolarPanelBlockEntity)!");
                    return null;
                }
                SolarPanelBlockEntity solarPanelBlockEntity = (SolarPanelBlockEntity)blockEntity;
                return new SolarPanelMenu(id, solarPanelBlockEntity, level);
            }), FeatureFlags.DEFAULT_FLAGS)));
            HELMET.put(level, (DeferredItem<Item>)ITEMS.registerItem(level.getSolarHelmetName(), properties -> new SolarHelmet(level, properties.stacksTo(1).component(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)0))));
            CORE.put(level, (DeferredItem<Item>)ITEMS.registerSimpleItem(level.getSolarCoreName()));
        }
    }
}

