/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.network.packet;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateSolarPanel(BlockPos pos, int currentEnergy, int currentProduction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateSolarPanel> TYPE = new CustomPacketPayload.Type(SolarGeneration.rl("update_solar_panel"));
    public static final StreamCodec<FriendlyByteBuf, UpdateSolarPanel> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateSolarPanel::pos, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateSolarPanel::currentEnergy, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateSolarPanel::currentProduction, UpdateSolarPanel::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateSolarPanel message, IPayloadContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.player().level();
        if (level.isLoaded(message.pos) && (blockEntity = level.getBlockEntity(message.pos)) instanceof SolarPanelBlockEntity) {
            SolarPanelBlockEntity solar = (SolarPanelBlockEntity)blockEntity;
            solar.energyClient = message.currentEnergy;
            solar.energyProductionClient = message.currentProduction;
        }
    }
}

