/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SolarHelmet
extends ArmorItem {
    private final SolarPanelLevel solarPanelLevel;
    private final int energyGeneration;
    private final int maxTransfer;

    public SolarHelmet(SolarPanelLevel solarPanelLevel, Item.Properties properties) {
        super(solarPanelLevel.getArmorMaterial(), ArmorItem.Type.HELMET, properties);
        this.solarPanelLevel = solarPanelLevel;
        this.energyGeneration = solarPanelLevel.getEnergyGeneration();
        this.maxTransfer = solarPanelLevel.getMaxTransfer();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int energy = (Integer)stack.getOrDefault(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)0);
        if (energy > 0) {
            tooltip.add((Component)Tooltip.showInfoCtrl(energy));
        }
        tooltip.addAll(Tooltip.showInfoShift(this.solarPanelLevel));
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return this.solarPanelLevel.getArmorTexture();
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.solarPanelLevel;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 0;
        }
        if (energy.getEnergyStored() == 0) {
            return 0;
        }
        double charge = (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
        return (int)Math.min(1.0 + 12.0 * charge, 13.0);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (slotId != 36 + EquipmentSlot.HEAD.getIndex()) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return;
        }
        if (energy.getEnergyStored() != energy.getMaxEnergyStored()) {
            energy.receiveEnergy(this.currentAmountEnergyProduced(level, (Player)player), false);
        }
        this.sendEnergy(energy, (Player)player);
    }

    private void sendEnergy(IEnergyStorage energy, Player player) {
        int i;
        Inventory inventory = player.getInventory();
        for (i = 36; i < 40 && energy.getEnergyStored() > 0; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.getItem() == this) continue;
            this.chargeItem(energy, item);
        }
        for (i = 0; i < 36 && energy.getEnergyStored() > 0; ++i) {
            this.chargeItem(energy, inventory.getItem(i));
        }
    }

    private void chargeItem(IEnergyStorage energyStorage, ItemStack receiver) {
        if (receiver.getCount() != 1) {
            return;
        }
        IEnergyStorage handler = (IEnergyStorage)receiver.getCapability(Capabilities.EnergyStorage.ITEM);
        if (handler == null) {
            return;
        }
        if (handler.canReceive()) {
            while (handler.getEnergyStored() < handler.getMaxEnergyStored() && energyStorage.getEnergyStored() > 0) {
                int accepted = Math.min(this.maxTransfer, handler.receiveEnergy(energyStorage.getEnergyStored(), true));
                energyStorage.extractEnergy(accepted, false);
                handler.receiveEnergy(accepted, false);
            }
        }
    }

    private int currentAmountEnergyProduced(Level level, Player player) {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(level, player.blockPosition().offset(0, 1, 0), this.getLevelSolarPanel()));
    }
}

