/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SolarGenerationBlockLoot
extends BlockLootSubProvider {
    public SolarGenerationBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    private LootTable.Builder createSolarPanelDrops(Block block) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)SolarGenerationDataComponents.ENERGY_COMPONENT.get())))));
    }

    protected void generate() {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            this.add((Block)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get(), this::createSolarPanelDrops);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return Registration.SOLAR_PANEL_BLOCK.values().stream().map(DeferredHolder::get).collect(Collectors.toList());
    }
}

