/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blocks.SolarPanelBlock;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class Recipes
extends RecipeProvider {
    public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.supportingItems(recipeOutput);
        this.solarPanelReverse(recipeOutput);
        this.solarHelmet(recipeOutput);
        this.solarPanel(recipeOutput);
        this.solarCore(recipeOutput);
    }

    private void supportingItems(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Registration.LAPIS_SHARD.get()).unlockedBy(Recipes.getHasName((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get())), Recipes.has((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get()))).save(recipeOutput, SolarGeneration.rl("lapis_lazuli_from_shard"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.LAPIS_SHARD.get()), (int)36).pattern("aa").pattern("aa").define(Character.valueOf('a'), (ItemLike)Items.LAPIS_LAZULI).unlockedBy(Recipes.getHasName((ItemLike)Items.LAPIS_LAZULI), Recipes.has((ItemLike)Items.LAPIS_LAZULI)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.PHOTOVOLTAIC_CELL.get())).pattern("aaa").pattern("bbb").pattern("ccc").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), (ItemLike)Registration.LAPIS_SHARD.get()).define(Character.valueOf('c'), Tags.Items.NUGGETS_IRON).unlockedBy(Recipes.getHasName((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get())), Recipes.has((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get()))).save(recipeOutput);
    }

    private void solarPanelReverse(RecipeOutput recipeOutput) {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SolarPanelBlock solarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            Item helmet = (Item)Registration.HELMET.get((Object)level).get();
            ResourceLocation resourceLocation = SolarGeneration.rl(level.getSolarPanelName() + "_reverse");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)solarPanel).requires((ItemLike)helmet).unlockedBy(Recipes.getHasName((ItemLike)helmet), Recipes.has((ItemLike)helmet)).save(recipeOutput, resourceLocation.toString());
        }
    }

    private void solarHelmet(RecipeOutput recipeOutput) {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SolarPanelBlock solarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            Item helmet = (Item)Registration.HELMET.get((Object)level).get();
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)helmet).requires((ItemLike)solarPanel).requires((ItemLike)this.getVanillaHelmet(level)).unlockedBy(Recipes.getHasName((ItemLike)solarPanel), Recipes.has((ItemLike)solarPanel)).save(recipeOutput);
        }
    }

    private void solarPanel(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.SOLAR_PANEL_BLOCK.get((Object)SolarPanelLevel.LEADSTONE).get())).pattern("aaa").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), (ItemLike)Registration.PHOTOVOLTAIC_CELL.get()).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get()).define(Character.valueOf('d'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/steel"))).unlockedBy(Recipes.getHasName((ItemLike)((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get())), Recipes.has((ItemLike)((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get()))).unlockedBy(Recipes.getHasName((ItemLike)((ItemLike)Registration.PHOTOVOLTAIC_CELL.get())), Recipes.has((ItemLike)((ItemLike)Registration.PHOTOVOLTAIC_CELL.get()))).save(recipeOutput);
        for (int i = 1; i < SolarPanelLevel.values().length; ++i) {
            SolarPanelLevel level = SolarPanelLevel.values()[i];
            SolarPanelBlock currentSolarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            SolarPanelBlock prevSolarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)SolarPanelLevel.values()[i - 1]).get());
            Item core = (Item)Registration.CORE.get((Object)level).get();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)currentSolarPanel).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)prevSolarPanel).define(Character.valueOf('b'), (ItemLike)core).unlockedBy(Recipes.getHasName((ItemLike)prevSolarPanel), Recipes.has((ItemLike)prevSolarPanel)).unlockedBy(Recipes.getHasName((ItemLike)core), Recipes.has((ItemLike)core)).save(recipeOutput);
        }
    }

    private void solarCore(RecipeOutput recipeOutput) {
        HashMap<SolarPanelLevel, ResourceLocation> materials = new HashMap<SolarPanelLevel, ResourceLocation>();
        materials.put(SolarPanelLevel.HARDENED, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/invar"));
        materials.put(SolarPanelLevel.REDSTONE, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/electrum"));
        materials.put(SolarPanelLevel.SIGNALUM, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/signalum"));
        materials.put(SolarPanelLevel.RESONANT, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/enderium"));
        materials.put(SolarPanelLevel.ADVANCED, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/lumium"));
        materials.put(SolarPanelLevel.ULTIMATE, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/platinum"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get())).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/lead"))).define(Character.valueOf('b'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/iron"))).unlockedBy(Recipes.getHasName((ItemLike)Items.IRON_INGOT), Recipes.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        for (int i = 1; i < SolarPanelLevel.values().length; ++i) {
            SolarPanelLevel level = SolarPanelLevel.values()[i];
            Item core = (Item)Registration.CORE.get((Object)level).get();
            Item prevCore = (Item)Registration.CORE.get((Object)SolarPanelLevel.values()[i - 1]).get();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)core).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), ItemTags.create((ResourceLocation)((ResourceLocation)materials.get((Object)level)))).define(Character.valueOf('b'), (ItemLike)prevCore).unlockedBy(Recipes.getHasName((ItemLike)prevCore), Recipes.has((ItemLike)prevCore)).save(recipeOutput);
        }
    }

    private Item getVanillaHelmet(SolarPanelLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case SolarPanelLevel.LEADSTONE, SolarPanelLevel.HARDENED -> Items.IRON_HELMET;
            case SolarPanelLevel.REDSTONE, SolarPanelLevel.SIGNALUM, SolarPanelLevel.RESONANT, SolarPanelLevel.ADVANCED -> Items.DIAMOND_HELMET;
            case SolarPanelLevel.ULTIMATE -> Items.NETHERITE_HELMET;
        };
    }
}

