/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.menu.SolarPanelMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    private static final ResourceLocation TEXTURE = SolarGeneration.rl("textures/gui/solar_panel.png");
    private final SolarPanelBlockEntity solarPanelBlockEntity;

    public SolarPanelScreen(SolarPanelMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.solarPanelBlockEntity = menu.solarPanelBlockEntity;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (mouseX > this.leftPos + 7 && mouseX < this.leftPos + 29 && mouseY > this.topPos + 10 && mouseY < this.topPos + 77) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.solargeneration.energy", (Object[])new Object[]{this.getPercent()}), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent energy = Component.translatable((String)"gui.solargeneration.stored_energy", (Object[])new Object[]{this.getEnergyFormatted(this.solarPanelBlockEntity.energyClient)});
        guiGraphics.drawString(this.font, (Component)energy, this.imageWidth / 2 - this.font.width((FormattedText)energy) / 2 + 14, 20, 0x404040, false);
        MutableComponent maxEnergy = Component.translatable((String)"gui.solargeneration.capacity", (Object[])new Object[]{this.getEnergyFormatted(this.solarPanelBlockEntity.getLevelSolarPanel().getCapacity())});
        guiGraphics.drawString(this.font, (Component)maxEnergy, this.imageWidth / 2 - this.font.width((FormattedText)maxEnergy) / 2 + 14, 30, 0x404040, false);
        MutableComponent generation = Component.translatable((String)"gui.solargeneration.generation", (Object[])new Object[]{this.solarPanelBlockEntity.energyProductionClient});
        guiGraphics.drawString(this.font, (Component)generation, this.imageWidth / 2 - this.font.width((FormattedText)generation) / 2 + 14, 40, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int y = this.getEnergyScaled(60);
        guiGraphics.blit(TEXTURE, this.leftPos + 10, this.topPos + 12 + y, this.imageWidth, 0, 16, 60 - y);
    }

    private String getEnergyFormatted(int energy) {
        if (energy >= 1000000) {
            return energy / 1000 + " kFE";
        }
        return energy + " FE";
    }

    private int getEnergyScaled(int pixels) {
        return pixels - pixels * this.getPercent() / 100;
    }

    private int getPercent() {
        long currentEnergy = this.solarPanelBlockEntity.energyClient;
        int maxEnergy = this.solarPanelBlockEntity.getLevelSolarPanel().getCapacity();
        long result = currentEnergy * 100L / (long)maxEnergy;
        return (int)result;
    }
}

