/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blocks;

import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape BOX = SolarPanelBlock.createShape();
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final SolarPanelLevel solarPanelLevel;

    public SolarPanelBlock(SolarPanelLevel solarPanelLevel, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.solarPanelLevel = solarPanelLevel;
    }

    private static VoxelShape createShape() {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(SolarPanelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        shapes.add(SolarPanelBlock.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));
        shapes.add(SolarPanelBlock.box((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanelBlock.box((double)9.0, (double)1.0, (double)9.0, (double)10.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanelBlock.box((double)9.0, (double)1.0, (double)6.0, (double)10.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanelBlock.box((double)6.0, (double)1.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanelBlock.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        VoxelShape combinedShape = Shapes.empty();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return combinedShape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.getBlockEntity(pos, (BlockEntityType)Registration.SOLAR_PANEL_BLOCK_ENTITY.get((Object)this.solarPanelLevel).get()).ifPresent(blockEntity -> serverPlayer.openMenu((MenuProvider)blockEntity, pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, level, pos, player, false, fluid);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        level.removeBlock(pos, false);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SolarPanelBlockEntity(this.solarPanelLevel, blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)Registration.SOLAR_PANEL_BLOCK_ENTITY.get((Object)this.solarPanelLevel).get()), SolarPanelBlockEntity::serverTick);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof SolarPanelBlockEntity) {
            IEnergyStorage energyStore = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, blockEntity.getBlockPos(), null);
            Integer energy = (Integer)itemStack.getOrDefault((DataComponentType)SolarGenerationDataComponents.ENERGY_COMPONENT.get(), (Object)0);
            if (energyStore != null) {
                ((SolarPanelBattery)energyStore).setEnergy(energy);
            }
        }
        super.setPlacedBy(level, pos, state, placer, itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        int energy = (Integer)itemStack.getOrDefault((DataComponentType)SolarGenerationDataComponents.ENERGY_COMPONENT.get(), (Object)0);
        if (energy > 0) {
            tooltip.add((Component)Tooltip.showInfoCtrl(energy));
        }
        tooltip.addAll(Tooltip.showInfoShift(this.solarPanelLevel));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.placeLiquid(levelAccessor, pos, state, fluidStateIn);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.canPlaceLiquid(player, blockGetter, pos, state, fluidIn);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }
}

