/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blockentity;

import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.network.packet.UpdateSolarPanel;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends BlockEntity
implements MenuProvider {
    private final int energyGeneration;
    private final int maxTransfer;
    private final SolarPanelBattery solarPanelBattery;
    private final SolarPanelLevel levelSolarPanel;
    public int energyClient;
    public int energyProductionClient;

    public SolarPanelBlockEntity(SolarPanelLevel levelSolarPanel, BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.SOLAR_PANEL_BLOCK_ENTITY.get((Object)levelSolarPanel).get(), pos, state);
        this.levelSolarPanel = levelSolarPanel;
        this.energyGeneration = levelSolarPanel.getEnergyGeneration();
        this.maxTransfer = levelSolarPanel.getMaxTransfer();
        int capacity = levelSolarPanel.getCapacity();
        this.solarPanelBattery = new SolarPanelBattery(this.maxTransfer, capacity);
        this.energyProductionClient = -1;
        this.energyClient = -1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SolarPanelBlockEntity solarPanel) {
        int energyProducedBySun = solarPanel.currentAmountEnergyProduced(level);
        solarPanel.solarPanelBattery.generatePower(energyProducedBySun);
        solarPanel.sendEnergy();
        int energyStored = solarPanel.solarPanelBattery.getEnergyStored();
        if (solarPanel.energyClient != energyStored || solarPanel.energyProductionClient != energyProducedBySun) {
            int energyProduced = solarPanel.solarPanelBattery.isFullEnergy() ? 0 : energyProducedBySun;
            solarPanel.setChanged();
            UpdateSolarPanel message = new UpdateSolarPanel(blockPos, energyStored, energyProduced);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunk(blockPos).getPos(), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private int currentAmountEnergyProduced(Level level) {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(level, this.worldPosition, this.levelSolarPanel));
    }

    private void sendEnergy() {
        int capacity = this.solarPanelBattery.getEnergyStored();
        for (int i = 0; i < Direction.values().length && capacity > 0; ++i) {
            IEnergyStorage energyStorage;
            Direction facing = Direction.values()[i];
            if (facing.equals((Object)Direction.UP) || (energyStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(facing), (Object)facing.getOpposite())) == null || !energyStorage.canReceive()) continue;
            int received = energyStorage.receiveEnergy(Math.min(capacity, this.maxTransfer), false);
            capacity -= received;
            this.solarPanelBattery.consumePower(received);
            this.setChanged();
        }
    }

    @Nullable
    public SolarPanelBattery getSolarPanelBattery(Direction direction) {
        return direction != Direction.UP ? this.solarPanelBattery : null;
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarPanel;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        Tag energyTag = tag.get("energy");
        if (energyTag != null) {
            this.solarPanelBattery.deserializeNBT(provider, energyTag);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("energy", this.solarPanelBattery.serializeNBT(provider));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        int energy = (Integer)componentInput.getOrDefault(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)0);
        this.solarPanelBattery.setEnergy(energy);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)this.solarPanelBattery.getEnergyStored());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SolarPanelMenu(id, this, this.levelSolarPanel);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }
}

