/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.function.Consumer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;

public class StorageHolderToolHandler {
    public static InteractionResult tryStorageToolInteract(ItemStack storageTool, StorageHolderBase storageHolder) {
        StorageToolItem.Mode mode = StorageToolItem.getMode(storageTool);
        switch (mode) {
            case LOCK: {
                if (!StorageHolderToolHandler.tryToggling(ILockable.class, ILockable::toggleLock, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
            case COUNT_DISPLAY: {
                if (!StorageHolderToolHandler.tryToggling(ICountDisplay.class, ICountDisplay::toggleCountVisibility, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
            case LOCK_DISPLAY: {
                if (!StorageHolderToolHandler.tryToggling(ILockable.class, ILockable::toggleLockVisibility, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
            case TIER_DISPLAY: {
                if (!StorageHolderToolHandler.tryToggling(ITierDisplay.class, ITierDisplay::toggleTierVisiblity, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
            case UPGRADES_DISPLAY: {
                if (!StorageHolderToolHandler.tryToggling(IUpgradeDisplay.class, IUpgradeDisplay::toggleUpgradesVisiblity, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
            case FILL_LEVEL_DISPLAY: {
                if (!StorageHolderToolHandler.tryToggling(IFillLevelDisplay.class, IFillLevelDisplay::toggleFillLevelVisibility, storageHolder)) break;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static <T> boolean tryToggling(Class<T> clazz, Consumer<T> doToggle, StorageHolderBase storageHolder) {
        if (clazz.isInstance(storageHolder)) {
            doToggle.accept(clazz.cast(storageHolder));
            return true;
        }
        return false;
    }
}

