/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MathHelpers {
    public static Vec3 lerp(Vec3 a, Vec3 b, float f) {
        return new Vec3(MathHelpers.lerp(a.x, b.x, (double)f), MathHelpers.lerp(a.y, b.y, (double)f), MathHelpers.lerp(a.z, b.z, (double)f));
    }

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction facing, AttachFace face) {
        if (shape.isEmpty()) {
            return shape;
        }
        double minX = shape.min(Direction.Axis.X);
        double maxX = shape.max(Direction.Axis.X);
        double minY = shape.min(Direction.Axis.Y);
        double maxY = shape.max(Direction.Axis.Y);
        double minZ = shape.min(Direction.Axis.Z);
        double maxZ = shape.max(Direction.Axis.Z);
        if (facing == Direction.NORTH) {
            if (face == AttachFace.FLOOR) {
                return shape;
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)(1.0 - maxX), (double)(1.0 - maxZ), (double)(1.0 - maxY), (double)(1.0 - minX), (double)(1.0 - minZ), (double)(1.0 - minY));
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)minX, (double)(1.0 - maxY), (double)(1.0 - maxZ), (double)maxX, (double)(1.0 - minY), (double)(1.0 - minZ));
            }
        }
        if (facing == Direction.SOUTH) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)(1.0 - maxX), (double)(1.0 - maxY), (double)minZ, (double)(1.0 - minX), (double)(1.0 - minY), (double)maxZ);
            }
        }
        if (facing == Direction.EAST) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)minY, (double)(1.0 - maxZ), (double)(1.0 - maxX), (double)maxY, (double)(1.0 - minZ), (double)(1.0 - minX));
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)minZ, (double)(1.0 - maxY), (double)minX, (double)maxZ, (double)(1.0 - minY), (double)maxX);
            }
        }
        if (facing == Direction.WEST) {
            if (face == AttachFace.FLOOR) {
                return Shapes.box((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
            }
            if (face == AttachFace.WALL) {
                return Shapes.box((double)(1.0 - maxY), (double)(1.0 - maxZ), (double)minX, (double)(1.0 - minY), (double)(1.0 - minZ), (double)maxX);
            }
            if (face == AttachFace.CEILING) {
                return Shapes.box((double)(1.0 - maxZ), (double)(1.0 - maxY), (double)(1.0 - maxX), (double)(1.0 - minZ), (double)(1.0 - minY), (double)(1.0 - minX));
            }
        }
        if (facing == Direction.UP) {
            return Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
        }
        if (facing == Direction.DOWN) {
            return Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
        }
        return shape;
    }
}

