/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.belts.BlockContent;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.ComponentContent;
import rearth.belts.ItemContent;
import rearth.belts.blocks.ChuteBlockEntity;

public class BeltItem
extends Item {
    public static boolean invalidCurve = false;

    public BeltItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide() && user.isShiftKeyDown()) {
            ItemStack stack = user.getItemInHand(hand);
            stack.remove((DataComponentType)ComponentContent.MIDPOINTS.get());
            stack.remove((DataComponentType)ComponentContent.BELT_START.get());
            stack.remove((DataComponentType)ComponentContent.BELT_DIR.get());
            user.sendSystemMessage((Component)Component.translatable((String)"message.belts.reset"));
        }
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState candidateState;
        ItemStack stack = context.getItemInHand();
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos targetBlockPos = context.getClickedPos();
        boolean hasStart = stack.has((DataComponentType)ComponentContent.BELT_START.get()) && stack.has((DataComponentType)ComponentContent.BELT_DIR.get());
        Optional chuteCandidate = context.getLevel().getBlockEntity(targetBlockPos, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (chuteCandidate.isPresent()) {
            ChuteBlockEntity chuteEntity = (ChuteBlockEntity)((Object)chuteCandidate.get());
            if (chuteEntity.isUsed()) {
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.belts.chute_used"));
                return InteractionResult.FAIL;
            }
            if (hasStart) {
                BlockPos startPos = (BlockPos)stack.get((DataComponentType)ComponentContent.BELT_START.get());
                Direction startDir = (Direction)stack.get((DataComponentType)ComponentContent.BELT_DIR.get());
                List midPoints = (List)stack.getOrDefault((DataComponentType)ComponentContent.MIDPOINTS.get(), new ArrayList());
                BlockPos endPos = targetBlockPos;
                Direction endDir = chuteEntity.getOwnFacing();
                this.createBelt(startPos, startDir, midPoints, endPos, endDir, context.getLevel(), context.getItemInHand(), context.getPlayer());
            } else {
                BlockPos startPos = targetBlockPos;
                Direction startDir = chuteEntity.getOwnFacing();
                stack.set((DataComponentType)ComponentContent.BELT_START.get(), (Object)startPos);
                stack.set((DataComponentType)ComponentContent.BELT_DIR.get(), (Object)startDir);
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.belts.started"));
            }
            return InteractionResult.SUCCESS;
        }
        BlockState supportCandidate = context.getLevel().getBlockState(targetBlockPos);
        if (hasStart && supportCandidate.getBlock().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            if (stack.has((DataComponentType)ComponentContent.MIDPOINTS.get())) {
                list.addAll((Collection)stack.get((DataComponentType)ComponentContent.MIDPOINTS.get()));
            }
            if (list.contains(targetBlockPos)) {
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.belts.midpoint_duplicate"));
                return InteractionResult.FAIL;
            }
            list.add(targetBlockPos);
            stack.set((DataComponentType)ComponentContent.MIDPOINTS.get(), list);
            context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.belts.midpoint_added"));
            return InteractionResult.SUCCESS;
        }
        Direction targetDir = context.getClickedFace();
        targetBlockPos = targetBlockPos.offset(context.getClickedFace().getNormal());
        if (context.getClickedFace().getAxis().equals((Object)Direction.Axis.Y)) {
            targetDir = context.getHorizontalDirection();
        }
        if ((candidateState = context.getLevel().getBlockState(targetBlockPos)).canBeReplaced() || candidateState.isAir()) {
            if (hasStart) {
                BlockPos startPos = (BlockPos)stack.get((DataComponentType)ComponentContent.BELT_START.get());
                Direction startDir = (Direction)stack.get((DataComponentType)ComponentContent.BELT_DIR.get());
                List midPoints = (List)stack.getOrDefault((DataComponentType)ComponentContent.MIDPOINTS.get(), new ArrayList());
                BlockPos endPos = targetBlockPos;
                Direction endDir = targetDir;
                this.createBelt(startPos, startDir, midPoints, endPos, endDir, context.getLevel(), context.getItemInHand(), context.getPlayer());
            } else {
                if (!context.getClickedFace().getAxis().equals((Object)Direction.Axis.Y)) {
                    targetDir = targetDir.getOpposite();
                }
                BlockPos startPos = targetBlockPos;
                Direction startDir = targetDir.getOpposite();
                stack.set((DataComponentType)ComponentContent.BELT_START.get(), (Object)startPos);
                stack.set((DataComponentType)ComponentContent.BELT_DIR.get(), (Object)startDir);
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.belts.started"));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void createBelt(BlockPos start, Direction startDir, List<BlockPos> supports, BlockPos end, Direction endDir, Level world, ItemStack stack, Player player) {
        stack.remove((DataComponentType)ComponentContent.MIDPOINTS.get());
        stack.remove((DataComponentType)ComponentContent.BELT_START.get());
        stack.remove((DataComponentType)ComponentContent.BELT_DIR.get());
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.belts.belt_created"));
        int createdChutes = 0;
        double distStart = start.distToCenterSqr((Position)player.position());
        double distEnd = end.distToCenterSqr((Position)player.position());
        BlockPos playfrom = distStart < distEnd ? start : end;
        world.playSound(null, playfrom, (SoundEvent)SoundEvents.BREEZE_WIND_CHARGE_BURST.value(), SoundSource.PLAYERS, 1.0f, 0.5f);
        BlockState startState = world.getBlockState(start);
        Optional startCandidate = world.getBlockEntity(start, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (startCandidate.isEmpty() && (startState.canBeReplaced() || startState.isAir())) {
            world.setBlockAndUpdate(start, (BlockState)((Block)BlockContent.CHUTE_BLOCK.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)startDir));
            startCandidate = world.getBlockEntity(start, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
            ++createdChutes;
        }
        BlockState endState = world.getBlockState(end);
        Optional endCandidate = world.getBlockEntity(end, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (endCandidate.isEmpty() && (endState.canBeReplaced() || endState.isAir())) {
            world.setBlockAndUpdate(end, (BlockState)((Block)BlockContent.CHUTE_BLOCK.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)endDir));
            endCandidate = world.getBlockEntity(end, (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
            ++createdChutes;
        }
        if (startCandidate.isPresent() && endCandidate.isPresent()) {
            ChuteBlockEntity startEntity = (ChuteBlockEntity)((Object)startCandidate.get());
            startEntity.assignFromBeltItem(end, supports);
        }
        if (createdChutes > 0) {
            int taken = 0;
            for (ItemStack playerItem : player.getInventory().items) {
                if (!playerItem.is((Item)ItemContent.CHUTE.get())) continue;
                int count = playerItem.getCount();
                int removed = Math.min(count, createdChutes);
                playerItem.shrink(removed);
                if ((taken += removed) < createdChutes) continue;
                break;
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        boolean showExtra;
        if (stack.has((DataComponentType)ComponentContent.BELT_START.get())) {
            BlockPos targetPos = (BlockPos)stack.get((DataComponentType)ComponentContent.BELT_START.get());
            tooltip.add((Component)Component.translatable((String)targetPos.toShortString()));
        }
        if (stack.has((DataComponentType)ComponentContent.MIDPOINTS.get())) {
            tooltip.add((Component)Component.translatable((String)"Midpoints: "));
            for (BlockPos midPoint : (List)stack.get((DataComponentType)ComponentContent.MIDPOINTS.get())) {
                tooltip.add((Component)Component.translatable((String)midPoint.toShortString()));
            }
        }
        if (showExtra = Screen.hasControlDown()) {
            for (int i = 0; i < 4; ++i) {
                tooltip.add((Component)Component.translatable((String)("item.belts.belt.tooltip." + i)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"message.belts.show_extra").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public static List<Tuple<BlockPos, Direction>> getStoredMidpoints(ItemStack stack, Level world) {
        ArrayList<Tuple<BlockPos, Direction>> res = new ArrayList<Tuple<BlockPos, Direction>>();
        if (stack.has((DataComponentType)ComponentContent.MIDPOINTS.get())) {
            ((List)stack.get((DataComponentType)ComponentContent.MIDPOINTS.get())).stream().filter(point -> world.getBlockState(point).getBlock().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())).map(point -> new Tuple(point, (Object)((Direction)world.getBlockState(point).getValue((Property)HorizontalDirectionalBlock.FACING)))).forEachOrdered(res::add);
        }
        return res;
    }
}

