/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.mixin;

import com.affehund.voidtotem.core.ILivingEntityMixin;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.mixin.ServerGamePacketListenerImplAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements ILivingEntityMixin {
    @Unique
    private boolean voidtotem$isFallDamageImmune;
    @Unique
    private long voidtotem$lastSaveBlockPos;
    @Unique
    private DimensionType voidtotem$lastSaveBlockDim;

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void voidtotem$checkTotemDeathProtection(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (ModUtils.canProtectFromVoid(livingEntity, source)) {
            ModUtils.handleVoidTotem(livingEntity);
            cir.setReturnValue((Object)true);
        } else if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && ModUtils.hasVoidTotem(livingEntity)) {
            ModUtils.handleDefaultTotemActivation(livingEntity);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void voidtotem$causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (((ILivingEntityMixin)livingEntity).voidtotem$isFallDamageImmune()) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.connection).setAboveGroundTickCount(0);
            }
            ((ILivingEntityMixin)livingEntity).voidtotem$setFallDamageImmune(false);
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        ModUtils.setLastSaveBlockPos(livingEntity);
        ModUtils.resetFallDamageImmunity(livingEntity);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt(@NotNull CompoundTag tag, CallbackInfo ci) {
        this.voidtotem$isFallDamageImmune = tag.getBoolean("VoidTotemIsFallDamageImmune");
        this.voidtotem$lastSaveBlockPos = tag.getLong("VoidTotemLastSaveBlockPos");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt(@NotNull CompoundTag tag, CallbackInfo ci) {
        tag.putBoolean("VoidTotemIsFallDamageImmune", this.voidtotem$isFallDamageImmune);
        tag.putLong("VoidTotemLastSaveBlockPos", this.voidtotem$lastSaveBlockPos);
    }

    @Override
    public boolean voidtotem$isFallDamageImmune() {
        return this.voidtotem$isFallDamageImmune;
    }

    @Override
    public void voidtotem$setFallDamageImmune(boolean isImmune) {
        this.voidtotem$isFallDamageImmune = isImmune;
    }

    @Override
    public long voidtotem$getLastSaveBlockPosAsLong() {
        return this.voidtotem$lastSaveBlockPos;
    }

    @Override
    public void voidtotem$setLastSaveBlockPosAsLong(long pos) {
        this.voidtotem$lastSaveBlockPos = pos;
    }

    @Override
    public DimensionType voidtotem$getLastSaveBlockDim() {
        return this.voidtotem$lastSaveBlockDim;
    }

    @Override
    public void voidtotem$setLastSaveBlockDim(DimensionType dimensionType) {
        this.voidtotem$lastSaveBlockDim = dimensionType;
    }
}

