/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.config.VoidTotemCommonConfig;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.data.VoidTotemDataGeneration;
import com.affehund.voidtotem.integration.CuriosCombatHandler;
import com.affehund.voidtotem.network.TotemEffectPacket;
import com.affehund.voidtotem.network.VoidTotemPayloadHandler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="voidtotem")
public class VoidTotemForge {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"voidtotem");
    public static final DeferredItem<Item> VOID_TOTEM_ITEM = ITEMS.registerSimpleItem("totem_of_void_undying", new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"voidtotem");
    public static final Supplier<SimpleParticleType> VOID_TOTEM_PARTICLE = PARTICLE_TYPES.register("void_totem", () -> new SimpleParticleType(false));

    public VoidTotemForge(IEventBus eventBus, ModContainer modContainer) {
        eventBus.addListener(this::addCreative);
        eventBus.addListener(this::gatherData);
        eventBus.addListener(this::registerPayloadHandler);
        if (ModUtils.isModLoaded("curios")) {
            eventBus.addListener(CuriosCombatHandler::registerCapabilities);
        }
        ITEMS.register(eventBus);
        PARTICLE_TYPES.register(eventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoidTotemCommonConfig.SPEC);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.insertAfter(new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING), new ItemStack((ItemLike)VOID_TOTEM_ITEM.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean isClientProvider = event.includeClient();
        boolean isServerProvider = event.includeServer();
        VoidTotemDataGeneration.BlockTagsGen blockTagsGen = new VoidTotemDataGeneration.BlockTagsGen(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(isServerProvider, (DataProvider)new AdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new VoidTotemDataGeneration.AdvancementGen())));
        generator.addProvider(isServerProvider, (DataProvider)blockTagsGen);
        generator.addProvider(isServerProvider, (DataProvider)new VoidTotemDataGeneration.RecipeGen(packOutput, lookupProvider));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(packOutput, "de_de"));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(packOutput, "en_us"));
        generator.addProvider(isClientProvider, (DataProvider)new VoidTotemDataGeneration.ItemModelGen(packOutput, existingFileHelper));
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        evt.registrar("voidtotem").playToClient(TotemEffectPacket.TYPE, TotemEffectPacket.STREAM_CODEC, VoidTotemPayloadHandler.getInstance()::handleUseTotem);
    }
}

