/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.CodecUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record PotionProviderRecipe(List<Holder<Potion>> potions, NonNullList<Ingredient> providers) implements Recipe<SingleRecipeInput>
{
    public String getGroup() {
        return "potion_provider";
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.providers;
    }

    public boolean matches(SingleRecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(SingleRecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Jeed.getPotionProviderSerializer();
    }

    public RecipeType<?> getType() {
        return Jeed.getPotionProviderType();
    }

    public List<? extends Holder<Potion>> getPotions() {
        return this.potions.isEmpty() ? BuiltInRegistries.POTION.holders().toList() : this.potions;
    }

    public static class Serializer
    implements RecipeSerializer<PotionProviderRecipe> {
        private static final MapCodec<PotionProviderRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.POTION.holderByNameCodec().listOf().optionalFieldOf("potions", List.of()).forGetter(r -> r.potions), (App)CodecUtil.INGREDIENT_WITH_TAG.listOf().fieldOf("providers").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No providers for potion providers recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(r -> r.providers)).apply((Applicative)instance, PotionProviderRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionProviderRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.POTION).apply(ByteBufCodecs.list()), PotionProviderRecipe::potions, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), PotionProviderRecipe::providers, PotionProviderRecipe::new);

        public MapCodec<PotionProviderRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionProviderRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

