/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.screen.EmiScreenManager;
import net.minecraft.client.Minecraft;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminalscompat.modcompat.common.button.TerminalButtonItemStackCraftingGridSearchSync;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.TerminalStorageEmiRecipeHandler;
import org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage.TerminalStorageEmiStackProvider;

@EmiEntrypoint
public class EmiIntegratedTerminalsConfig
implements EmiPlugin {
    private boolean loaded = false;
    private boolean wasEmiVisible = false;

    public EmiIntegratedTerminalsConfig() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static int getItemStackMatchCondition(ItemStack itemStack) {
        Comparison comparison = EmiComparisonDefaults.get((Object)itemStack.getItem());
        return comparison == Comparison.DEFAULT_COMPARISON ? 1 : 5;
    }

    public void register(EmiRegistry emiRegistry) {
        this.loaded = true;
        emiRegistry.addRecipeHandler((MenuType)RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_PART.get(), new TerminalStorageEmiRecipeHandler());
        emiRegistry.addRecipeHandler((MenuType)RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM.get(), new TerminalStorageEmiRecipeHandler());
        emiRegistry.addGenericStackProvider((EmiStackProvider)new TerminalStorageEmiStackProvider());
        emiRegistry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemStack)new ItemStack((ItemLike)PartTypes.TERMINAL_STORAGE.getItem())));
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        if (this.loaded && !event.getButtons().stream().anyMatch(button -> button instanceof TerminalButtonItemStackCraftingGridSearchSync)) {
            event.getButtons().add(new TerminalButtonItemStackCraftingGridSearchSync("emi", event.getContainer().getGuiState(), event.getClientTab(), Images.BUTTON_MIDDLE_EMI_SYNC));
        }
    }

    @SubscribeEvent
    public void onTerminalStorageScreenSize(TerminalStorageScreenSizeEvent event) {
        if (this.loaded) {
            try {
                boolean isOpen = !EmiScreenManager.isDisabled();
                boolean wasJeiVisiblePrevious = this.wasEmiVisible;
                if (isOpen) {
                    this.wasEmiVisible = true;
                    event.setHeight(event.getHeight() - 20);
                    event.setWidth(event.getWidth() - 170);
                } else {
                    this.wasEmiVisible = false;
                }
                if (wasJeiVisiblePrevious != this.wasEmiVisible) {
                    ((ContainerScreenTerminalStorage)Minecraft.getInstance().screen).init();
                }
            }
            catch (ClassCastException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (!EmiScreenManager.isDisabled() && TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(event.getClientTab())) {
            EmiApi.setSearchText((String)event.getSearchString());
        }
    }

    @SubscribeEvent
    public void onKeyTyped(ScreenEvent.KeyReleased.Post event) {
        if (event.getScreen() instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage gui = (ContainerScreenTerminalStorage)event.getScreen();
            if (!EmiScreenManager.isDisabled() && EmiApi.isSearchFocused()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(tab)) {
                        WidgetTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.setValue(EmiApi.getSearchText());
                        tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)gui.getMenu()))).getSelectedChannel(), fieldSearch.getValue());
                    }
                });
            }
        }
    }
}

