/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageBoatItem
extends MovingStorageItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private static final String RAFT_DESCRIPTION_ID = "item.sophisticatedstorageinmotion.storage_raft";
    public static final Map<Boat.Type, Supplier<Item>> SUPPORTED_BOAT_TYPES = Map.of(Boat.Type.ACACIA, () -> Items.ACACIA_BOAT, Boat.Type.BAMBOO, () -> Items.BAMBOO_RAFT, Boat.Type.BIRCH, () -> Items.BIRCH_BOAT, Boat.Type.CHERRY, () -> Items.CHERRY_BOAT, Boat.Type.DARK_OAK, () -> Items.DARK_OAK_BOAT, Boat.Type.JUNGLE, () -> Items.JUNGLE_BOAT, Boat.Type.MANGROVE, () -> Items.MANGROVE_BOAT, Boat.Type.OAK, () -> Items.OAK_BOAT, Boat.Type.SPRUCE, () -> Items.SPRUCE_BOAT);
    public static final DefaultDispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double yOffset;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            double halfWidth = 0.5625 + (double)EntityType.BOAT.getWidth() / 2.0;
            Vec3 center = source.center();
            double x = center.x() + (double)direction.getStepX() * halfWidth;
            double y = center.y() + (double)direction.getStepY() * 1.125;
            double z = center.z() + (double)direction.getStepZ() * halfWidth;
            BlockPos blockpos = source.pos().relative(direction);
            Boat boat = StorageBoatItem.createBoat((Level)level, null, stack, x, y, z);
            boat.setYRot(direction.toYRot());
            if (boat.canBoatInFluid(level.getFluidState(blockpos))) {
                yOffset = 1.0;
            } else {
                if (!level.getBlockState(blockpos).isAir() || !boat.canBoatInFluid(level.getFluidState(blockpos.below()))) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                yOffset = 0.0;
            }
            boat.setPos(x, y + yOffset, z);
            level.addFreshEntity((Entity)boat);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public StorageBoatItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)SUPPORTED_BOAT_TYPES.getOrDefault(StorageBoatItem.getBoatType(input), () -> Items.OAK_BOAT).get());
    }

    @Override
    public List<ItemStack> getBaseMovingStorageItems() {
        return SUPPORTED_BOAT_TYPES.keySet().stream().map(type -> StorageBoatItem.setBoatType(new ItemStack((ItemLike)this), type)).toList();
    }

    public static Boat.Type getBoatType(ItemStack boatStack) {
        return (Boat.Type)boatStack.getOrDefault(ModDataComponents.BOAT_TYPE.get(), (Object)Boat.Type.OAK);
    }

    public static ItemStack setBoatType(ItemStack boatStack, Boat.Type type) {
        boatStack.set(ModDataComponents.BOAT_TYPE.get(), (Object)type);
        return boatStack;
    }

    @Override
    public Component getName(ItemStack stack) {
        SimpleItemContent storageItemContent = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        Boat.Type boatType = StorageBoatItem.getBoatType(stack);
        String descriptionId = boatType.isRaft() ? RAFT_DESCRIPTION_ID : this.getDescriptionId();
        return Component.translatable((String)descriptionId, (Object[])new Object[]{this.getWoodName(boatType), storageItemContent != null ? storageItemContent.copy().getHoverName() : ""});
    }

    private Component getWoodName(Boat.Type type) {
        return Component.translatable((String)("wood_name.sophisticatedstorage." + type.name().toLowerCase(Locale.ROOT)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = StorageBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 playerViewVector = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(playerViewVector.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePosition = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(eyePosition)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            Vec3 location = hitresult.getLocation();
            Boat boat = StorageBoatItem.createBoat(level, player, itemstack, location.x, location.y, location.z);
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                itemstack.consume(1, (LivingEntity)player);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private static Boat createBoat(Level level, @Nullable Player player, ItemStack stack, double x, double y, double z) {
        StorageBoat boat = new StorageBoat(level, x, y, z);
        EntityStorageHolder<?> storageHolder = boat.getStorageHolder();
        storageHolder.setStorageItemAndCustomNameFromMovingStorageStack(stack, true);
        storageHolder.onPlace();
        boat.setVariant(StorageBoatItem.getBoatType(stack));
        if (player != null) {
            boat.setYRot(player.getYRot());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)stack, (Player)player).accept(boat);
        }
        return boat;
    }
}

