/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create;

import com.simibubi.create.AllBlocks;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.api.BaseChiselingRecipes;
import com.supermartijn642.rechiseled.create.RechiseledCreate;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RechiseledCreateRecipes {
    public static final ResourceLocation ACACIA_WINDOW = RechiseledCreateRecipes.location("acacia_window");
    public static final ResourceLocation ANDESITE = BaseChiselingRecipes.ANDESITE;
    public static final ResourceLocation ASURINE = RechiseledCreateRecipes.location("asurine");
    public static final ResourceLocation BIRCH_WINDOW = RechiseledCreateRecipes.location("birch_window");
    public static final ResourceLocation CALCITE = RechiseledCreateRecipes.location("calcite");
    public static final ResourceLocation CRIMSITE = RechiseledCreateRecipes.location("crimsite");
    public static final ResourceLocation CRIMSON_WINDOW = RechiseledCreateRecipes.location("crimson_window");
    public static final ResourceLocation DARK_OAK_WINDOW = RechiseledCreateRecipes.location("dark_oak_window");
    public static final ResourceLocation DEEPSLATE = RechiseledCreateRecipes.location("deepslate");
    public static final ResourceLocation DIORITE = BaseChiselingRecipes.DIORITE;
    public static final ResourceLocation DRIPSTONE = RechiseledCreateRecipes.location("dripstone");
    public static final ResourceLocation GLASS = RechiseledCreateRecipes.location("glass");
    public static final ResourceLocation GRANITE = BaseChiselingRecipes.GRANITE;
    public static final ResourceLocation JUNGLE_WINDOW = RechiseledCreateRecipes.location("jungle_window");
    public static final ResourceLocation LIMESTONE = RechiseledCreateRecipes.location("limestone");
    public static final ResourceLocation MANGROVE_WINDOW = RechiseledCreateRecipes.location("mangrove_window");
    public static final ResourceLocation OCHRUM = RechiseledCreateRecipes.location("ochrum");
    public static final ResourceLocation OAK_WINDOW = RechiseledCreateRecipes.location("oak_window");
    public static final ResourceLocation POLISHED_ROSE_QUARTZ = RechiseledCreateRecipes.location("polished_rose_quartz");
    public static final ResourceLocation SCORCHIA = RechiseledCreateRecipes.location("scorchia");
    public static final ResourceLocation SCORIA = RechiseledCreateRecipes.location("scoria");
    public static final ResourceLocation SPRUCE_WINDOW = RechiseledCreateRecipes.location("spruce_window");
    public static final ResourceLocation TUFF = RechiseledCreateRecipes.location("tuff");
    public static final ResourceLocation VERIDIUM = RechiseledCreateRecipes.location("veridium");
    public static final ResourceLocation WARPED_WINDOW = RechiseledCreateRecipes.location("warped_window");

    private static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"rechiseledcreate", (String)name);
    }

    private static Supplier<ItemLike> getBlock(String identifier) {
        ResourceLocation location = ResourceLocation.parse((String)identifier);
        return () -> {
            if (!Registries.BLOCKS.hasIdentifier(location)) {
                throw new RuntimeException("Unknown block '" + identifier + "'!");
            }
            return (ItemLike)Registries.BLOCKS.getValue(location);
        };
    }

    public static void init() {
        RechiseledCreateRecipes.connectingBlockOnly(ACACIA_WINDOW, "create:acacia_window");
        RechiseledCreateRecipes.regularSet(ANDESITE, "create:cut_andesite");
        RechiseledCreateRecipes.regularSet(ANDESITE, "create:cut_andesite_bricks", "create:cut_andesite_brick_stairs", "create:cut_andesite_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(ANDESITE, "create:layered_andesite");
        RechiseledCreateRecipes.connectingBlockOnly(ANDESITE, "create:andesite_pillar");
        RechiseledCreateRecipes.regularBlockOnly(ASURINE, "create:asurine");
        RechiseledCreateRecipes.regularSet(ASURINE, "create:cut_asurine");
        RechiseledCreateRecipes.regularSet(ASURINE, "create:cut_asurine_bricks", "create:cut_asurine_brick_stairs", "create:cut_asurine_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(ASURINE, "create:layered_asurine");
        RechiseledCreateRecipes.connectingBlockOnly(ASURINE, "create:asurine_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(BIRCH_WINDOW, "create:birch_window");
        RechiseledCreateRecipes.regularBlockOnly(CALCITE, () -> Items.CALCITE);
        RechiseledCreateRecipes.regularSet(CALCITE, "create:cut_calcite");
        RechiseledCreateRecipes.regularSet(CALCITE, "create:cut_calcite_bricks", "create:cut_calcite_brick_stairs", "create:cut_calcite_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(CALCITE, "create:layered_calcite");
        RechiseledCreateRecipes.connectingBlockOnly(CALCITE, "create:calcite_pillar");
        RechiseledCreateRecipes.regularBlockOnly(CRIMSITE, "create:crimsite");
        RechiseledCreateRecipes.regularSet(CRIMSITE, "create:cut_crimsite");
        RechiseledCreateRecipes.regularSet(CRIMSITE, "create:cut_crimsite_bricks", "create:cut_crimsite_brick_stairs", "create:cut_crimsite_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(CRIMSITE, "create:layered_crimsite");
        RechiseledCreateRecipes.connectingBlockOnly(CRIMSITE, "create:crimsite_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(CRIMSON_WINDOW, "create:crimson_window");
        RechiseledCreateRecipes.connectingBlockOnly(DARK_OAK_WINDOW, "create:dark_oak_window");
        RechiseledCreateRecipes.regularBlockOnly(DEEPSLATE, () -> Items.DEEPSLATE);
        RechiseledCreateRecipes.regularSet(DEEPSLATE, "create:cut_deepslate");
        RechiseledCreateRecipes.regularSet(DEEPSLATE, "create:cut_deepslate_bricks", "create:cut_deepslate_brick_stairs", "create:cut_deepslate_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(DEEPSLATE, "create:layered_deepslate");
        RechiseledCreateRecipes.connectingBlockOnly(DEEPSLATE, "create:deepslate_pillar");
        RechiseledCreateRecipes.regularSet(DIORITE, "create:cut_diorite");
        RechiseledCreateRecipes.regularSet(DIORITE, "create:cut_diorite_bricks", "create:cut_diorite_brick_stairs", "create:cut_diorite_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(DIORITE, "create:layered_diorite");
        RechiseledCreateRecipes.connectingBlockOnly(DIORITE, "create:diorite_pillar");
        RechiseledCreateRecipes.regularBlockOnly(DRIPSTONE, () -> Items.DRIPSTONE_BLOCK);
        RechiseledCreateRecipes.regularSet(DRIPSTONE, "create:cut_dripstone");
        RechiseledCreateRecipes.regularSet(DRIPSTONE, "create:cut_dripstone_bricks", "create:cut_dripstone_brick_stairs", "create:cut_dripstone_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(DRIPSTONE, "create:layered_dripstone");
        RechiseledCreateRecipes.connectingBlockOnly(DRIPSTONE, "create:dripstone_pillar");
        RechiseledCreateRecipes.regularBlockOnly(GLASS, () -> Items.GLASS);
        RechiseledCreateRecipes.regularBlockOnly(GLASS, "create:tiled_glass");
        RechiseledCreateRecipes.connectingBlockOnly(GLASS, "create:framed_glass");
        RechiseledCreateRecipes.connectingBlockOnly(GLASS, "create:horizontal_framed_glass");
        RechiseledCreateRecipes.connectingBlockOnly(GLASS, "create:vertical_framed_glass");
        RechiseledCreateRecipes.regularSet(GRANITE, "create:cut_granite");
        RechiseledCreateRecipes.regularSet(GRANITE, "create:cut_granite_bricks", "create:cut_granite_brick_stairs", "create:cut_granite_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(GRANITE, "create:layered_granite");
        RechiseledCreateRecipes.connectingBlockOnly(GRANITE, "create:granite_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(JUNGLE_WINDOW, "create:jungle_window");
        RechiseledCreateRecipes.regularBlockOnly(LIMESTONE, RechiseledCreateRecipes.getBlock("create:limestone"));
        RechiseledCreateRecipes.regularSet(LIMESTONE, "create:cut_limestone");
        RechiseledCreateRecipes.regularSet(LIMESTONE, "create:cut_limestone_bricks", "create:cut_limestone_brick_stairs", "create:cut_limestone_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(LIMESTONE, "create:layered_limestone");
        RechiseledCreateRecipes.connectingBlockOnly(LIMESTONE, "create:limestone_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(MANGROVE_WINDOW, "create:mangrove_window");
        RechiseledCreateRecipes.connectingBlockOnly(OAK_WINDOW, "create:oak_window");
        RechiseledCreateRecipes.regularBlockOnly(OCHRUM, "create:ochrum");
        RechiseledCreateRecipes.regularSet(OCHRUM, "create:cut_ochrum");
        RechiseledCreateRecipes.regularSet(OCHRUM, "create:cut_ochrum_bricks", "create:cut_ochrum_brick_stairs", "create:cut_ochrum_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(OCHRUM, "create:layered_ochrum");
        RechiseledCreateRecipes.connectingBlockOnly(OCHRUM, "create:ochrum_pillar");
        RechiseledCreateRecipes.regularBlockOnly(POLISHED_ROSE_QUARTZ, () -> ((BlockEntry)AllBlocks.SMALL_ROSE_QUARTZ_TILES).get());
        RechiseledCreateRecipes.regularBlockOnly(SCORCHIA, "create:scorchia");
        RechiseledCreateRecipes.regularSet(SCORCHIA, "create:cut_scorchia");
        RechiseledCreateRecipes.regularSet(SCORCHIA, "create:cut_scorchia_bricks", "create:cut_scorchia_brick_stairs", "create:cut_scorchia_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(SCORCHIA, "create:layered_scorchia");
        RechiseledCreateRecipes.connectingBlockOnly(SCORCHIA, "create:scorchia_pillar");
        RechiseledCreateRecipes.regularBlockOnly(SCORIA, "create:scoria");
        RechiseledCreateRecipes.regularSet(SCORIA, "create:cut_scoria");
        RechiseledCreateRecipes.regularSet(SCORIA, "create:cut_scoria_bricks", "create:cut_scoria_brick_stairs", "create:cut_scoria_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(SCORIA, "create:layered_scoria");
        RechiseledCreateRecipes.connectingBlockOnly(SCORIA, "create:scoria_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(SPRUCE_WINDOW, "create:spruce_window");
        RechiseledCreateRecipes.regularBlockOnly(TUFF, () -> Items.TUFF);
        RechiseledCreateRecipes.regularSet(TUFF, "create:cut_tuff");
        RechiseledCreateRecipes.regularSet(TUFF, "create:cut_tuff_bricks", "create:cut_tuff_brick_stairs", "create:cut_tuff_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(TUFF, "create:layered_tuff");
        RechiseledCreateRecipes.connectingBlockOnly(TUFF, "create:tuff_pillar");
        RechiseledCreateRecipes.regularBlockOnly(VERIDIUM, "create:veridium");
        RechiseledCreateRecipes.regularSet(VERIDIUM, "create:cut_veridium");
        RechiseledCreateRecipes.regularSet(VERIDIUM, "create:cut_veridium_bricks", "create:cut_veridium_brick_stairs", "create:cut_veridium_brick_slab");
        RechiseledCreateRecipes.connectingBlockOnly(VERIDIUM, "create:layered_veridium");
        RechiseledCreateRecipes.connectingBlockOnly(VERIDIUM, "create:veridium_pillar");
        RechiseledCreateRecipes.connectingBlockOnly(WARPED_WINDOW, "create:warped_window");
    }

    private static void regularBlockOnly(ResourceLocation recipe, Supplier<ItemLike> block) {
        RechiseledCreate.REGISTRATION.chiselingEntry(recipe, entry -> entry.regularBlock((ItemLike)block.get()));
    }

    private static void regularBlockOnly(ResourceLocation recipe, String blockIdentifier) {
        RechiseledCreateRecipes.regularBlockOnly(recipe, RechiseledCreateRecipes.getBlock(blockIdentifier));
    }

    private static void connectingBlockOnly(ResourceLocation recipe, Supplier<ItemLike> block) {
        RechiseledCreate.REGISTRATION.chiselingEntry(recipe, entry -> entry.connectingBlock((ItemLike)block.get()));
    }

    private static void connectingBlockOnly(ResourceLocation recipe, String blockIdentifier) {
        RechiseledCreateRecipes.connectingBlockOnly(recipe, RechiseledCreateRecipes.getBlock(blockIdentifier));
    }

    private static void regularSet(ResourceLocation recipe, String blockIdentifier, String stairsIdentifier, String slabIdentifier) {
        Supplier<ItemLike> block = RechiseledCreateRecipes.getBlock(blockIdentifier);
        Supplier<ItemLike> stairs = RechiseledCreateRecipes.getBlock(stairsIdentifier);
        Supplier<ItemLike> slab = RechiseledCreateRecipes.getBlock(slabIdentifier);
        RechiseledCreate.REGISTRATION.chiselingEntry(recipe, entry -> {
            entry.regularBlock((ItemLike)block.get());
            entry.regularStairs((ItemLike)stairs.get());
            entry.regularSlab((ItemLike)slab.get());
        });
    }

    private static void regularSet(ResourceLocation recipe, String identifier) {
        RechiseledCreateRecipes.regularSet(recipe, identifier, identifier + "_stairs", identifier + "_slab");
    }
}

