/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.client.gui.tooltip;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.item.component.ChalkBoxContents;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientChalkBoxTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation TEXTURE = Chalk.resource("textures/gui/container/chalk_box_tooltip.png");
    private static final int ROWS = 4;
    private static final int COLUMNS = 2;
    private final ChalkBoxContents contents;

    public ClientChalkBoxTooltip(ChalkBoxContents contents) {
        this.contents = contents;
    }

    public int getHeight() {
        return this.backgroundHeight() + 2;
    }

    public int getWidth(@NotNull Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return 76;
    }

    private int backgroundHeight() {
        boolean showGlowingStuff = (Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get() != false && (this.contents.glowAmount() > 0 || !this.contents.items().get(8).isEmpty());
        return showGlowingStuff ? 69 : 42;
    }

    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        boolean showGlowingStuff;
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth(), 41, 128, 128);
        int selectedIndex = this.contents.getSelectedChalkIndex();
        int index = 0;
        for (int c = 0; c < 2; ++c) {
            for (int r = 0; r < 4; ++r) {
                int px = x + r * 18 + 2;
                int py = y + c * 18 + 2;
                this.renderSlot(px, py, index, guiGraphics, font);
                if (index == selectedIndex) {
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(px + 1), (int)(py + 1), (int)0);
                }
                ++index;
            }
        }
        boolean bl = showGlowingStuff = (Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get() != false && (this.contents.glowAmount() > 0 || !this.contents.items().get(8).isEmpty());
        if (showGlowingStuff) {
            guiGraphics.blit(TEXTURE, x, y + 38, 0.0f, 41.0f, this.backgroundWidth(), 30, 128, 128);
            this.renderSlot(x + 29, y + 47, index, guiGraphics, font);
            if (this.contents.glowAmount() > 0) {
                int maxWidth = 72;
                float fill = (float)this.contents.glowAmount() / (float)((Integer)Config.Common.CHALK_BOX_GLOWING_AMOUNT_PER_ITEM.get()).intValue();
                int fillWidth = Math.min((int)Math.floor((float)maxWidth * fill), maxWidth);
                guiGraphics.blit(TEXTURE, x + 2, y + 40, 0.0f, 71.0f, fillWidth, 5, 128, 128);
            }
        }
    }

    private void renderSlot(int x, int y, int index, GuiGraphics guiGraphics, Font font) {
        ItemStack itemstack = this.contents.items().get(index);
        guiGraphics.renderItem(itemstack, x + 1, y + 1, index);
        guiGraphics.renderItemDecorations(font, itemstack, x + 1, y + 1);
    }
}

