/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.advancement.predicate.DyeColorPredicate;
import io.github.mortuusars.chalk.advancement.predicate.MapColorPredicate;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MarkDrawnTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, MapColor surfaceColor, DyeColor chalkColor) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, surfaceColor, chalkColor));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<LocationPredicate> location, Optional<MapColorPredicate> surfaceColor, Optional<DyeColorPredicate> markColor) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)MapColorPredicate.CODEC.optionalFieldOf("surface_color").forGetter(TriggerInstance::surfaceColor), (App)DyeColorPredicate.CODEC.optionalFieldOf("mark_color").forGetter(TriggerInstance::markColor)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> structure(Holder<Structure> structureKey) {
            TriggerInstance instance = new TriggerInstance(EntityPredicate.wrap(Optional.empty()), Optional.of(LocationPredicate.Builder.inStructure(structureKey).build()), Optional.of(new MapColorPredicate(Collections.emptyList())), Optional.of(new DyeColorPredicate(Collections.emptyList())));
            return ((MarkDrawnTrigger)((Object)Chalk.CriteriaTriggers.MARK_DRAWN.get())).createCriterion((CriterionTriggerInstance)instance);
        }

        public boolean matches(ServerPlayer player, MapColor surfaceColor, DyeColor markColor) {
            return !(!this.location.isEmpty() && !this.location.get().matches(player.serverLevel(), player.getX(), player.getY(), player.getZ()) || !this.surfaceColor.isEmpty() && !this.surfaceColor.get().matches(surfaceColor) || !this.markColor.isEmpty() && !this.markColor.get().matches(markColor));
        }
    }
}

