/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import edivad.dimstorage.setup.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;

public class DimCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> root = Commands.literal((String)"dimtablet");

    public static void init(CommandDispatcher<CommandSourceStack> dispatcher) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(cs -> cs.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Item item = player.getMainHandItem().getItem();
            if (Config.DimTablet.addItem(item)) {
                player.displayClientMessage((Component)Component.literal((String)"Item added to the list").withStyle(ChatFormatting.GREEN), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"You must select a valid item").withStyle(ChatFormatting.RED), false);
            }
            return 0;
        }));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(cs -> cs.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Item item = player.getMainHandItem().getItem();
            if (Config.DimTablet.removeItem(item)) {
                player.displayClientMessage((Component)Component.literal((String)"Item removed from the list").withStyle(ChatFormatting.GREEN), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"You must select a valid item").withStyle(ChatFormatting.RED), false);
            }
            return 0;
        }));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"removeAll").requires(cs -> cs.hasPermission(0))).executes(context -> {
            Config.DimTablet.ALLOW_LIST.set(new ArrayList());
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.displayClientMessage((Component)Component.literal((String)"Removed all items from the list").withStyle(ChatFormatting.GREEN), false);
            return 0;
        }));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(0))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            player.displayClientMessage((Component)Component.literal((String)"These are the items that the DimTablet will move:"), false);
            ((List)Config.DimTablet.ALLOW_LIST.get()).stream().map(Component::literal).forEach(item -> player.displayClientMessage((Component)item, false));
            return 0;
        }));
        LiteralCommandNode rootNode = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"dimstorage").redirect((CommandNode)rootNode));
    }
}

