/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.tab;

import fr.addonslib.api.data.ModType;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.ModList;

public class NewIconRandom {

    public static class NewProperties {
        private final EnumSet<ModType> activeTypes = EnumSet.noneOf(ModType.class);
        private final Block roofsIcon;
        private final Block fencesIcon;
        private final Block furnituresIcon;
        private final Block bridgesIcon;
        private final Block windowsIcon;
        private final Block doorsIcon;
        private final Block trapdoorsIcon;
        private final Block pathsIcon;
        private final Block stairsIcon;
        private int dependencies = 0;
        public Block defaultIcon = Blocks.CRAFTING_TABLE;

        public NewProperties(Block roofsIcon, Block fencesIcon, Block furnituresIcon, Block bridgesIcon, Block windowsIcon, Block doorsIcon, Block trapdoorsIcon, Block pathsIcon, Block stairsIcon) {
            this.bridgesIcon = bridgesIcon;
            this.roofsIcon = roofsIcon;
            this.fencesIcon = fencesIcon;
            this.furnituresIcon = furnituresIcon;
            this.windowsIcon = windowsIcon;
            this.doorsIcon = doorsIcon;
            this.trapdoorsIcon = trapdoorsIcon;
            this.pathsIcon = pathsIcon;
            this.stairsIcon = stairsIcon;
        }

        public NewProperties addType(ModType type) {
            this.activeTypes.add(type);
            return this;
        }

        public Block buildIcon(ModType ... types) {
            for (ModType type : types) {
                if (!this.isTypeLoaded(type)) continue;
                ++this.dependencies;
            }
            if (this.allTypesLoaded(types)) {
                return this.getRandomIcon(types);
            }
            return this.getFallbackIcon(types);
        }

        private Block getRandomIcon(ModType ... types) {
            Random rand = new Random();
            int i = rand.nextInt(this.dependencies);
            switch (types[i]) {
                case BRIDGES: {
                    return this.bridgesIcon;
                }
                case FENCES: {
                    return this.fencesIcon;
                }
                case ROOFS: {
                    return this.roofsIcon;
                }
                case FURNITURES: {
                    return this.furnituresIcon;
                }
                case PATHS: {
                    return this.pathsIcon;
                }
                case TRAPDOORS: {
                    return this.trapdoorsIcon;
                }
                case DOORS: {
                    return this.doorsIcon;
                }
                case WINDOWS: {
                    return this.windowsIcon;
                }
                case STAIRS: {
                    return this.stairsIcon;
                }
            }
            return this.defaultIcon;
        }

        private boolean isTypeLoaded(ModType type) {
            String modId = this.getModIdForType(type);
            return ModList.get().isLoaded(modId);
        }

        private boolean allTypesLoaded(ModType ... types) {
            for (ModType type : types) {
                if (this.isTypeLoaded(type)) continue;
                return false;
            }
            return true;
        }

        private String getModIdForType(ModType type) {
            switch (type) {
                case ROOFS: {
                    return ModType.ROOFS.getModid();
                }
                case FENCES: {
                    return ModType.FENCES.getModid();
                }
                case BRIDGES: {
                    return ModType.BRIDGES.getModid();
                }
                case FURNITURES: {
                    return ModType.FURNITURES.getModid();
                }
                case WINDOWS: {
                    return ModType.WINDOWS.getModid();
                }
                case DOORS: {
                    return ModType.DOORS.getModid();
                }
                case TRAPDOORS: {
                    return ModType.TRAPDOORS.getModid();
                }
                case PATHS: {
                    return ModType.PATHS.getModid();
                }
                case STAIRS: {
                    return ModType.STAIRS.getModid();
                }
            }
            return "";
        }

        private Block getFallbackIcon(ModType ... types) {
            for (ModType type : types) {
                if (!this.isTypeLoaded(type)) continue;
                return this.getIconForType(type);
            }
            return this.defaultIcon;
        }

        private Block getIconForType(ModType type) {
            switch (type) {
                case ROOFS: {
                    return this.roofsIcon;
                }
                case FENCES: {
                    return this.fencesIcon;
                }
                case BRIDGES: {
                    return this.bridgesIcon;
                }
                case FURNITURES: {
                    return this.furnituresIcon;
                }
                case WINDOWS: {
                    return this.windowsIcon;
                }
                case DOORS: {
                    return this.doorsIcon;
                }
                case TRAPDOORS: {
                    return this.trapdoorsIcon;
                }
                case PATHS: {
                    return this.pathsIcon;
                }
                case STAIRS: {
                    return this.stairsIcon;
                }
            }
            return this.defaultIcon;
        }
    }
}

