/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.registry;

import fr.addonslib.api.data.BlockId;
import fr.addonslib.api.data.McwBlockIdBase;
import fr.addonslib.api.data.McwBlocksIdBase;
import fr.addonslib.api.data.ModType;
import fr.addonslib.api.registry.ConditionalsRegistry;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.registry.McwProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class McwRegistry {
    private McwRegistry() {
    }

    public static Map<String, SoundType> makeDefaultFromList(List<String> list, SoundType soundType) {
        LinkedHashMap<String, SoundType> map = new LinkedHashMap<String, SoundType>();
        for (String str : list) {
            map.put(str, soundType);
        }
        return map;
    }

    public static void setRegistriesWood(List<String> list, DeferredRegister.Blocks block, DeferredRegister.Items item, ModType ... type) {
        McwRegistry.setRegistriesWood(McwRegistry.makeDefaultFromList(list, SoundType.WOOD), block, item, type);
    }

    public static void setRegistriesWood(Map<String, SoundType> stringSoundTypeMap, DeferredRegister.Blocks block, DeferredRegister.Items item, ModType ... type) {
        ModList modList = ModList.get();
        LinkedHashMap<String, SoundType> orderedMap = new LinkedHashMap<String, SoundType>(stringSoundTypeMap);
        for (ModType mod : type) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                SoundType soundType = (SoundType)map.getValue();
                BlockSetType blockSetType = McwRegistry.getBlockSetType(soundType);
                WoodType woodType = McwRegistry.getWoodType(soundType);
                McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidWood(mod);
                for (BlockId blockId : mcwBlockIdBase.blocks()) {
                    String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                    String reflectedLocation = blockId.reflectedLocation().getForge();
                    boolean isModLoaded = modList.isLoaded(mcwBlockIdBase.modid());
                    BlockBehaviour.Properties prop = soundType == SoundType.GLASS ? McwProperties.getWoodProperties(mat, mod).noOcclusion().sound(soundType) : McwProperties.getWoodProperties(mat, mod).sound(soundType);
                    if (isModLoaded) {
                        if (ConditionalsRegistry.isBlockDefaultState("1.17.1", reflectedLocation)) {
                            CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop, Blocks.OAK_PLANKS.defaultBlockState()), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isBlockSetType(reflectedLocation)) {
                            CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop, blockSetType), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isFence(reflectedLocation)) {
                            CreateBlockReferences.createBlock(id, () -> new FenceBlock(prop), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isFenceGate(reflectedLocation)) {
                            CreateBlockReferences.createBlock(id, () -> new FenceGateBlock(woodType, prop), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isTrapdoor(id)) {
                            CreateBlockReferences.createBlock(id, () -> new TrapDoorBlock(blockSetType, prop), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isDoor(id)) {
                            CreateBlockReferences.createBlock(id, () -> new DoorBlock(blockSetType, prop), block, item);
                            continue;
                        }
                        CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, () -> new Block(prop), block, item);
                }
            }
        }
    }

    public static void setRegistriesLeave(List<String> list, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        McwRegistry.setRegistriesLeave(McwRegistry.makeDefaultFromList(list, SoundType.GRASS), block, item);
    }

    public static void setRegistriesLeave(Map<String, SoundType> stringSoundTypeMap, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        ModList modList = ModList.get();
        LinkedHashMap<String, SoundType> orderedMap = new LinkedHashMap<String, SoundType>(stringSoundTypeMap);
        McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidLeave(ModType.FENCES);
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                SoundType soundType = (SoundType)map.getValue();
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                boolean isModLoaded = modList.isLoaded(mcwBlockIdBase.modid());
                BlockBehaviour.Properties prop = McwProperties.getLeaveProperties().sound(soundType);
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new FenceBlock(prop), block, item);
            }
        }
    }

    public static void setRegistriesStone(List<String> list, DeferredRegister.Blocks block, DeferredRegister.Items item, ModType ... type) {
        McwRegistry.setRegistriesStone(McwRegistry.makeDefaultFromList(list, SoundType.STONE), block, item, type);
    }

    public static void setRegistriesStone(Map<String, SoundType> stringSoundTypeMap, DeferredRegister.Blocks block, DeferredRegister.Items item, ModType ... type) {
        ModList modList = ModList.get();
        LinkedHashMap<String, SoundType> orderedMap = new LinkedHashMap<String, SoundType>(stringSoundTypeMap);
        for (ModType mod : type) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                SoundType soundType = (SoundType)map.getValue();
                WoodType woodType = McwRegistry.getWoodType(soundType);
                McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidStone(mod);
                for (BlockId blockId : mcwBlockIdBase.blocks()) {
                    String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                    String reflectedLocation = blockId.reflectedLocation().getForge();
                    boolean isModLoaded = modList.isLoaded(mcwBlockIdBase.modid());
                    BlockBehaviour.Properties prop = McwProperties.getStoneProperties(mod).sound(soundType);
                    if (isModLoaded) {
                        if (ConditionalsRegistry.isBlockDefaultState("1.17.1", reflectedLocation)) {
                            CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop, Blocks.STONE.defaultBlockState()), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isFence(reflectedLocation)) {
                            CreateBlockReferences.createBlockStone(id, () -> new FenceBlock(prop), block, item);
                            continue;
                        }
                        if (ConditionalsRegistry.isFenceGate(reflectedLocation)) {
                            CreateBlockReferences.createBlockStone(id, () -> new FenceGateBlock(woodType, prop), block, item);
                            continue;
                        }
                        CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation().getForge(), prop), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlockStone(id, () -> new Block(prop), block, item);
                }
            }
        }
    }

    private static BlockSetType getBlockSetType(SoundType soundType) {
        if (soundType == SoundType.CHERRY_WOOD) {
            return BlockSetType.CHERRY;
        }
        if (soundType == SoundType.NETHER_WOOD) {
            return BlockSetType.CRIMSON;
        }
        if (soundType == SoundType.BAMBOO_WOOD) {
            return BlockSetType.BAMBOO;
        }
        return BlockSetType.OAK;
    }

    private static WoodType getWoodType(SoundType soundType) {
        if (soundType == SoundType.CHERRY_WOOD) {
            return WoodType.CHERRY;
        }
        if (soundType == SoundType.NETHER_WOOD) {
            return WoodType.CRIMSON;
        }
        if (soundType == SoundType.BAMBOO_WOOD) {
            return WoodType.BAMBOO;
        }
        return WoodType.OAK;
    }
}

