/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.registry;

import fr.addonslib.api.data.ModType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class McwProperties {
    private static BlockBehaviour.Properties getBridgesWoodProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    }

    private static BlockBehaviour.Properties getBridgesStoneProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANDESITE);
    }

    private static BlockBehaviour.Properties getStairsWoodProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.WOOD);
    }

    private static BlockBehaviour.Properties getStairsStoneProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.STONE);
    }

    private static BlockBehaviour.Properties getDoorsJapWoodProperties() {
        return BlockBehaviour.Properties.of().noOcclusion().strength(1.5f, 1.0f).sound(SoundType.SCAFFOLDING);
    }

    private static BlockBehaviour.Properties getDoorsNormalWoodProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR);
    }

    private static BlockBehaviour.Properties getFencesNormalWoodProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    }

    private static BlockBehaviour.Properties getFencesCurvedWoodProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).noOcclusion();
    }

    private static BlockBehaviour.Properties getFencesStoneProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANDESITE);
    }

    private static BlockBehaviour.Properties getRoofsWoodProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.WOOD);
    }

    private static BlockBehaviour.Properties getRoofsStoneProperties() {
        return BlockBehaviour.Properties.of().strength(1.5f, 3.0f).sound(SoundType.STONE).requiresCorrectToolForDrops();
    }

    private static BlockBehaviour.Properties getPathsWoodProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    }

    private static BlockBehaviour.Properties getWindowsWoodProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.6f, 1.2f);
    }

    private static BlockBehaviour.Properties getTrapdoorsWoodProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR);
    }

    private static BlockBehaviour.Properties getFurnituresWoodProperties() {
        return BlockBehaviour.Properties.of().strength(2.0f, 2.3f);
    }

    public static BlockBehaviour.Properties getWoodProperties(String mat, ModType modType) {
        return switch (modType) {
            case ModType.BRIDGES -> McwProperties.getBridgesWoodProperties();
            case ModType.STAIRS -> McwProperties.getStairsWoodProperties();
            case ModType.DOORS -> {
                if (mat.contains("japanese")) {
                    yield McwProperties.getDoorsJapWoodProperties();
                }
                yield McwProperties.getDoorsNormalWoodProperties();
            }
            case ModType.FENCES -> {
                if (mat.contains("curved_gate")) {
                    yield McwProperties.getFencesCurvedWoodProperties();
                }
                yield McwProperties.getFencesNormalWoodProperties();
            }
            case ModType.ROOFS -> McwProperties.getRoofsWoodProperties();
            case ModType.PATHS -> McwProperties.getPathsWoodProperties();
            case ModType.WINDOWS -> McwProperties.getWindowsWoodProperties();
            case ModType.TRAPDOORS -> McwProperties.getTrapdoorsWoodProperties();
            case ModType.FURNITURES -> McwProperties.getFurnituresWoodProperties();
            default -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
        };
    }

    public static BlockBehaviour.Properties getLeaveProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES);
    }

    public static BlockBehaviour.Properties getStoneProperties(ModType modType) {
        return switch (modType) {
            case ModType.BRIDGES -> McwProperties.getBridgesStoneProperties();
            case ModType.STAIRS -> McwProperties.getStairsStoneProperties();
            case ModType.FENCES -> McwProperties.getFencesStoneProperties();
            case ModType.ROOFS -> McwProperties.getRoofsStoneProperties();
            default -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANDESITE);
        };
    }
}

